
module netcdf_kit

    use netcdf

    implicit none
    
    real, parameter :: sc_fac_default = 1.
    real, parameter :: add_off_default = 0.
    
!     type var_type
!         real :: varid
!         real :: sc_fac
!         real :: add_off
!     
!     end type
!     
!     type netcdf_kit_type
!         integer :: ncid
!         integer :: nvar
!         integer, allocatable :: varid(:)
!         integer :: tt
!     end type
    
    
contains

    subroutine nc_errhand(ios)
        integer, intent(in) :: ios
        real :: a = 1.
        if (ios /= nf90_noerr) then
            print*, trim(nf90_strerror(ios))
            print*, 1./(a-a)  ! crash
        endif
    end subroutine

!     subroutine nc_open(filename, ncid)
!         character(*), intent(in) :: filename
!         integer, intent(out) :: ncid
!         
!         call nc_errhand( nf90_open(filename, nf90_nowrite, ncid) )
!         
!     end subroutine
!     
!     subroutine nc_close(ncid)
!         integer, intent(in) :: ncid
!         call nc_errhand( nf90_close(ncid) )
!         end subroutine
    
    
!         subroutine nc_read(ncid, varname, var1, var2, var3, var4, var5, start, count)
!                   integer, intent(in) :: ncid
!             character(*), intent(in) :: varname
!             real, intent(out) :: var(:)
!             integer, intent(in) :: start(:), count(:)
    
    
    subroutine nc_read_1d(ncid, varname, var, start, count)
        
        integer, intent(in) :: ncid
        character(*), intent(in) :: varname
        real, intent(out) :: var(:)
        integer, intent(in) :: start(:), count(:)
        
        integer :: varid, ios
        real :: sc_fac, add_off
        
        call nc_errhand( nf90_inq_varid(ncid, varname, varid) )
        ios = nf90_get_att(ncid, varid, 'scale_factor', sc_fac)
        if (ios /= 0) sc_fac = sc_fac_default
        ios = nf90_get_att(ncid, varid, 'add_offset', add_off)
        if (ios /= 0) add_off = add_off_default
        
        call nc_errhand( nf90_get_var(ncid, varid, var, start, count) )
        var = var * sc_fac + add_off
        
    end subroutine
    
    subroutine nc_read_2d(ncid, varname, var, start, count)
        
        integer, intent(in) :: ncid
        character(*), intent(in) :: varname
        real, intent(out) :: var(:,:)
        integer, intent(in) :: start(:), count(:)
        
        integer :: varid, ios
        real :: sc_fac, add_off
        
        call nc_errhand( nf90_inq_varid(ncid, varname, varid) )
        ios = nf90_get_att(ncid, varid, 'scale_factor', sc_fac)
        if (ios /= 0) sc_fac = sc_fac_default
        ios = nf90_get_att(ncid, varid, 'add_offset', add_off)
        if (ios /= 0) add_off = add_off_default
        
        call nc_errhand( nf90_get_var(ncid, varid, var, start, count) )
        var = var * sc_fac + add_off
        
    end subroutine
    
    subroutine nc_read_3d(ncid, varname, var, start, count)
        
        integer, intent(in) :: ncid
        character(*), intent(in) :: varname
        real, intent(out) :: var(:,:,:)
        integer, intent(in) :: start(:), count(:)
        
        integer :: varid, ios
        real :: sc_fac, add_off
        
        call nc_errhand( nf90_inq_varid(ncid, varname, varid) )
        ios = nf90_get_att(ncid, varid, 'scale_factor', sc_fac)
        if (ios /= 0) sc_fac = sc_fac_default
        ios = nf90_get_att(ncid, varid, 'add_offset', add_off)
        if (ios /= 0) add_off = add_off_default
        
        call nc_errhand( nf90_get_var(ncid, varid, var, start, count) )
        var = var * sc_fac + add_off
        
    end subroutine
    
    subroutine nc_read_4d(ncid, varname, var, start, count)
        
        integer, intent(in) :: ncid
        character(*), intent(in) :: varname
        real, intent(out) :: var(:,:,:,:)
        integer, intent(in) :: start(:), count(:)
        
        integer :: varid, ios
        real :: sc_fac, add_off
        
        call nc_errhand( nf90_inq_varid(ncid, varname, varid) )
        ios = nf90_get_att(ncid, varid, 'scale_factor', sc_fac)
        if (ios /= 0) sc_fac = sc_fac_default
        ios = nf90_get_att(ncid, varid, 'add_offset', add_off)
        if (ios /= 0) add_off = add_off_default
        
        call nc_errhand( nf90_get_var(ncid, varid, var, start, count) )
        var = var * sc_fac + add_off
        
    end subroutine
    
    
    subroutine nc_read_5d(ncid, varname, var, start, count)
        
        integer, intent(in) :: ncid
        character(*), intent(in) :: varname
        real, intent(out) :: var(:,:,:,:,:)
        integer, intent(in) :: start(:), count(:)
        
        integer :: varid, ios
        real :: sc_fac, add_off
        
        call nc_errhand( nf90_inq_varid(ncid, varname, varid) )
        ios = nf90_get_att(ncid, varid, 'scale_factor', sc_fac)
        if (ios /= 0) sc_fac = sc_fac_default
        ios = nf90_get_att(ncid, varid, 'add_offset', add_off)
        if (ios /= 0) add_off = add_off_default
        
        call nc_errhand( nf90_get_var(ncid, varid, var, start, count) )
        var = var * sc_fac + add_off
        
    end subroutine

end module
