
module environment_data_lsm_offline

    ! интерфейс
    ! ---------------------------------------------------------------------------------

    use environment_core, only : Temp, e, Rlwd, Rswd, p, pr, Wind, ra, Tsrf, Tsoil, Wsoil, Isoil, snow, Tgr
    use netcdf
    use netcdf_kit, only : nc_errhand, nc_read_2d, nc_read_3d, nc_read_4d
    use config, only : lsm_datafile, nc_namespace, if_datafile_read_at_first
    use grid, only : ms
    
    implicit none
    
    private
    public :: environment_data_init
    public :: environment_data_calc_at_timestep
    public :: environment_data_calc_at_cell
    public :: environment_data_calc_at_tile

    ! параметры
    ! ---------------------------------------------------------------------------------
    
    integer, parameter :: ms_fst = ms + 1       ! диапазон глубин во входном файле
    integer, parameter :: ms_lst = ms + 13
    integer, parameter :: nlev = ms_lst - ms_fst + 1
    
    ! переменные
    ! ---------------------------------------------------------------------------------
    
    real, allocatable, dimension(:,:,:) :: io_us, io_vs, io_ta, io_qa, io_ps, io_p, io_rsw, io_rlw
    real, allocatable, dimension(:,:,:) :: io_tsrf1, io_tgr, io_s, io_ga
    real, allocatable, dimension(:,:,:,:) :: io_tsoil, io_wsoil, io_isoil

    integer :: start3(3), count3(3)
    integer :: start4(4), count4(4)
    integer :: ncid, ncycle, i_fst, j_fst


contains


    ! внешние процедуры
    ! ---------------------------------------------------------------------------------

    subroutine environment_data_init()
        ! ---------------------------------------
        use grid, only : dt, i0, i1, j0, j1, ni, nj, i0_nc, j0_nc, nt_nc
        
        call nc_errhand( nf90_open(trim(lsm_datafile), nf90_nowrite, ncid) )
        
        i_fst = i0 - i0_nc + 1
        j_fst = j0 - j0_nc + 1
        ncycle = nt_nc
        
        if (if_datafile_read_at_first) then
        
            print*, 'подготовка данных форсинга...'
            
            ! allocate(io_us(i0:i1,j0:j1,ncycle))
            ! allocate(io_vs(i0:i1,j0:j1,ncycle))
            allocate(io_ta(i0:i1,j0:j1,ncycle))
            allocate(io_qa(i0:i1,j0:j1,ncycle))
            allocate(io_ps(i0:i1,j0:j1,ncycle))
            ! allocate(io_p(i0:i1,j0:j1,ncycle))
            allocate(io_rsw(i0:i1,j0:j1,ncycle))
            ! allocate(io_rlw(i0:i1,j0:j1,ncycle))
            allocate(io_tsrf1(i0:i1,j0:j1,ncycle))
            allocate(io_tgr(i0:i1,j0:j1,ncycle))
            allocate(io_s(i0:i1,j0:j1,ncycle))
            allocate(io_ga(i0:i1,j0:j1,ncycle))
            allocate(io_tsoil(i0:i1,j0:j1,ms_fst:ms_lst,ncycle))
            allocate(io_wsoil(i0:i1,j0:j1,ms_fst:ms_lst,ncycle))
            allocate(io_isoil(i0:i1,j0:j1,ms_fst:ms_lst,ncycle))
            
            start3(:) = (/i_fst,j_fst,1/)
            count3(:) = (/ni,nj,ncycle/)
            start4(:) = (/i_fst,j_fst,1,1/)
            count4(:) = (/ni,nj,nlev,ncycle/)
            
            ! call nc_read_3d(ncid,trim(nc_namespace%us),io_us,start3,count3)
            ! call nc_read_3d(ncid,trim(nc_namespace%vs),io_vs,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%ta),io_ta,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%qa),io_qa,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%ps),io_ps,start3,count3)
            ! call nc_read_3d(ncid,trim(nc_namespace%p),io_p,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%rsw),io_rsw,start3,count3)
            ! call nc_read_3d(ncid,trim(nc_namespace%rlw),io_rlw,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%tsrf1),io_tsrf1,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%tgr),io_tgr,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%s),io_s,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%ga),io_ga,start3,count3)
            call nc_read_4d(ncid,trim(nc_namespace%tsoil),io_tsoil,start4,count4)
            call nc_read_4d(ncid,trim(nc_namespace%wsoil),io_wsoil,start4,count4)
            call nc_read_4d(ncid,trim(nc_namespace%isoil),io_isoil,start4,count4)
            call nc_errhand( nf90_close(ncid) )
        else
        
            ! allocate(io_us(i0:i1,j0:j1,1))
            ! allocate(io_vs(i0:i1,j0:j1,1))
            allocate(io_ta(i0:i1,j0:j1,1))
            allocate(io_qa(i0:i1,j0:j1,1))
            allocate(io_ps(i0:i1,j0:j1,1))
            ! allocate(io_p(i0:i1,j0:j1,1))
            allocate(io_rsw(i0:i1,j0:j1,1))
            ! allocate(io_rlw(i0:i1,j0:j1,1))
            allocate(io_tsrf1(i0:i1,j0:j1,1))
            allocate(io_tgr(i0:i1,j0:j1,1))
            allocate(io_s(i0:i1,j0:j1,1))
            allocate(io_ga(i0:i1,j0:j1,1))
            allocate(io_tsoil(i0:i1,j0:j1,ms_fst:ms_lst,1))
            allocate(io_wsoil(i0:i1,j0:j1,ms_fst:ms_lst,1))
            allocate(io_isoil(i0:i1,j0:j1,ms_fst:ms_lst,1))
        
        endif
        
    end subroutine


    subroutine environment_data_calc_at_timestep()
        ! ---------------------------------------
        use const, only : bar2hPa, cm2mm, q2e, Kelvin0, miss_v
        use grid, only : i0, i1, j0, j1, tt, ni, nj, mask
        integer :: i, j, t
        
        t = mod(tt-1,ncycle)+1
        
        if (if_datafile_read_at_first) then
            ! ...
        else
        
            start3(:) = (/i_fst,j_fst,t/)
            count3(:) = (/ni,nj,1/)
            start4(:) = (/i_fst,j_fst,1,t/)
            count4(:) = (/ni,nj,nlev,1/)
        
            ! call nc_read_3d(ncid,trim(nc_namespace%us),io_us,start3,count3)
            ! call nc_read_3d(ncid,trim(nc_namespace%vs),io_vs,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%ta),io_ta,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%qa),io_qa,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%ps),io_ps,start3,count3)
            ! call nc_read_3d(ncid,trim(nc_namespace%p),io_p,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%rsw),io_rsw,start3,count3)
            ! call nc_read_3d(ncid,trim(nc_namespace%rlw),io_rlw,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%tsrf1),io_tsrf1,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%tgr),io_tgr,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%s),io_s,start3,count3)
            call nc_read_3d(ncid,trim(nc_namespace%ga),io_ga,start3,count3)
            call nc_read_4d(ncid,trim(nc_namespace%tsoil),io_tsoil,start4,count4)
            call nc_read_4d(ncid,trim(nc_namespace%wsoil),io_wsoil,start4,count4)
            call nc_read_4d(ncid,trim(nc_namespace%isoil),io_isoil,start4,count4)
            t = 1
        endif
        
        do i = i0, i1
            do j = j0, j1
                if (mask(i,j) == 1) then
                    Temp(i,j) = io_ta(i,j,t) - Kelvin0
                    Wind(i,j) = miss_v  ! sqrt(io_us(i,j,t)**2 + io_vs(i,j,t)**2)
                    p(i,j) = io_ps(i,j,t) * bar2hPa
                    e(i,j) = q2e(io_qa(i,j,t),io_ps(i,j,t)) * bar2hPa
                    Rswd(i,j) = io_rsw(i,j,t)
                    Rlwd(i,j) = miss_v  ! io_rlw(i,j,t)
                    pr(i,j) = miss_v    ! io_p(i,j,t) * cm2mm
                    Tsrf(i,j) = io_tsrf1(i,j,t) - Kelvin0
                    Tgr(i,j) = io_tgr(i,j,t)
                    snow(i,j) = io_s(i,j,t)
                    ra(i,j) = 20.       ! 1./io_ga(i,j,t)
                    Tsoil(i,j,ms_fst:ms_lst) = io_tsoil(i,j,:,t)
                    Wsoil(i,j,ms_fst:ms_lst) = io_wsoil(i,j,:,t)
                    Isoil(i,j,ms_fst:ms_lst) = io_isoil(i,j,:,t)
                endif
            end do
        end do

    end subroutine

    subroutine environment_data_calc_at_cell(ii,jj)
        ! ---------------------------------------
        integer, intent(in) :: ii, jj
    end subroutine
    
    subroutine environment_data_calc_at_tile(ii,jj,nn)
        ! ---------------------------------------
        integer, intent(in) :: ii, jj, nn
    end subroutine
        
end module
