
module environment_data_generator

    ! интерфейс
    ! ---------------------------------------------------------------------------------

    use environment_core, only : Temp, e, Rlwd, Rswd, p, pr, Wind, ra, Tsrf, Tsoil, Wsoil, Isoil, snow, Tgr

    implicit none

    private
    public :: environment_data_init
    public :: environment_data_calc_at_timestep
    public :: environment_data_calc_at_cell
    public :: environment_data_calc_at_tile


contains


    ! внешние процедуры
    ! ---------------------------------------------------------------------------------

    subroutine environment_data_init()
        ! ---------------------------------------
    end subroutine


    subroutine environment_data_calc_at_timestep()
        ! ---------------------------------------
        use const, only : w_day, miss_v
        use grid, only : i0, i1, j0, j1, date_c, z, ms, ml
        integer :: i, j, k
        real :: hour, x

        hour = date_c%h
        
        do i = i0, i1
            do j = j0, j1
                Temp(i,j) = 20. + 5.*cos(w_day*(hour-13))      !< temperature of air
                Wind(i,j) = 2 + 1.*cos(w_day*(hour-13))        !< wind
                p(i,j) = 980.                                  !< pressure
                e(i,j) = 15. + 2.*cos(2*w_day*(hour-7))        !< humidity
                Rswd(i,j) = max(0.,800.*cos(w_day*(hour-12)))  !< shortwave radiation
                Rlwd(i,j) = 350.                               !< longwave radiation
                pr(i,j) = 0.                                   !< precipitation
                ra(i,j) = 20.                                  !< aerodynamical resistance
                snow(i,j) = 0.
				! veg(i,j) = 0.7
                ! ---
                Tsrf(i,j) = 20. + 8.*cos(w_day*(hour-12.5))    !< temperature of surface
                Tgr(i,j) = Tsrf(i,j)
                do k = 1, ms-1
                    Tsoil(i,j,:) = miss_v
                    Wsoil(i,j,:) = miss_v
                    Isoil(i,j,:) = miss_v
                end do
                do k = ms, ml
                    x = (z(k)-z(ms))/(z(ml)-z(ms))  ! линейная интерполяция
                    Tsoil(i,j,:) = 20.-15*x + (5.-4*x)*cos(w_day*(hour-13-3*x))
                    Wsoil(i,j,:) = 0.2
                    Isoil(i,j,:) = 0.
                end do
            end do
        end do

    end subroutine

    
    subroutine environment_data_calc_at_cell(ii,jj)
        ! ---------------------------------------
        integer, intent(in) :: ii, jj
    end subroutine
    
    subroutine environment_data_calc_at_tile(ii,jj,nn)
        ! ---------------------------------------
        integer, intent(in) :: ii, jj, nn
    end subroutine

end module
