
module environment_core

    ! интерфейс
    ! ---------------------------------------------------------------------------------

    implicit none

    private
    public :: Temp, e, Rswd, Rlwd, p, pr, Wind, Tsrf, Tgr, snow, ra, Tsoil, Wsoil, Isoil
    public :: sw, bettar, veg, kd, lambd, organic, FYM, rhodry, g2gw_to_cmw, Evpar
    public :: environment_core_init
    
    ! переменные
    ! ---------------------------------------------------------------------------------
    
    real, allocatable, dimension(:,:), target :: Temp       !< Temperature of air, [Celsius]
    real, allocatable, dimension(:,:), target :: e          !< Humidity function, [hPa]
    real, allocatable, dimension(:,:), target :: Rswd       !< Radiation short wave flux (downstream), [W/m2]
    real, allocatable, dimension(:,:), target :: Rlwd       !< Radiation long wave flux (downstream), [W/m2]
    real, allocatable, dimension(:,:), target :: p          !< Pressure, [hPa]
    real, allocatable, dimension(:,:), target :: pr         !< Precipitation, [mm/s]
    real, allocatable, dimension(:,:), target :: Wind       !< Wind speed, [m/s]
    real, allocatable, dimension(:,:), target :: Tsrf       !< Temperature of surface, [Celsius]
    real, allocatable, dimension(:,:), target :: Tgr
    real, allocatable, dimension(:,:), target :: snow       !< Snow water-equivalent height, [m]
    real, allocatable, dimension(:,:), target :: ra         !< Turbulent aerodynamical resistance in atmosphere surface layer, [c/m]
    real, allocatable, dimension(:,:,:), target :: Tsoil    !< Temerature at soil on depth levels, [Celsius]
    real, allocatable, dimension(:,:,:), target :: Wsoil    !< Mass water content at soil on depth levels, [g/g]
    real, allocatable, dimension(:,:,:), target :: Isoil    !< Mass ice content at soil on depth levels, [g/g]
    
    real, allocatable, dimension(:,:), target :: sw         !< Влажность увядания
    real, allocatable, dimension(:,:), target :: bettar     !< Fraction of soil respiration, [%] from 0 to 1
    real, allocatable, dimension(:,:), target :: veg        !< Средняя концентрация растений в интервал времени dt, [%]
    real, allocatable, dimension(:,:), target :: kd         !< Коэф. перехода углерода из C2 в C1, десорбация, разрушение агрегатов
    real, allocatable, dimension(:,:), target :: lambd      !< Поступление углерода в почву в интервал времени dt
    real, allocatable, dimension(:,:), target :: organic    !< Поступление углерода, в виде органики, в почву в интервал времени dt  
    real, allocatable, dimension(:,:), target :: FYM        !< Поступление углерода, в виде навоза,  в почву в интервал времени dt
    real, allocatable, dimension(:,:,:), target :: rhodry   !< плотность сухой почвы, г/см3
    real, allocatable, dimension(:,:,:), target :: g2gw_to_cmw       !< г/г воды в см воды в слоях почвы

    real, allocatable, dimension(:,:), target :: Evpar      !< Evaporation   

contains
    
    
    ! внешние процедуры
    ! ---------------------------------------------------------------------------------
    
    subroutine environment_core_init()
        ! ---------------------------------------
        use const, only : miss_v
        use grid, only : i0, i1, j0, j1, ml
        
        allocate(Temp(i0:i1,j0:j1))
        allocate(e(i0:i1,j0:j1))
        allocate(Rswd(i0:i1,j0:j1))
        allocate(Rlwd(i0:i1,j0:j1))
        allocate(p(i0:i1,j0:j1))
        allocate(pr(i0:i1,j0:j1))
        allocate(Wind(i0:i1,j0:j1))
        allocate(Tsrf(i0:i1,j0:j1))
        allocate(Tgr(i0:i1,j0:j1))
        allocate(snow(i0:i1,j0:j1))
        allocate(ra(i0:i1,j0:j1))
        allocate(Tsoil(i0:i1,j0:j1,ml))
        allocate(Wsoil(i0:i1,j0:j1,ml))
        allocate(Isoil(i0:i1,j0:j1,ml))

        allocate(sw(i0:i1,j0:j1))
        allocate(bettar(i0:i1,j0:j1))
        allocate(veg(i0:i1,j0:j1))
        allocate(kd(i0:i1,j0:j1))
		allocate(lambd(i0:i1,j0:j1))
		allocate(organic(i0:i1,j0:j1))
		allocate(FYM(i0:i1,j0:j1))

		allocate(rhodry(i0:i1,j0:j1,ml))
		allocate(g2gw_to_cmw(i0:i1,j0:j1,ml))
		allocate(Evpar(i0:i1,j0:j1))

        g2gw_to_cmw = miss_v
        rhodry = miss_v
        sw = miss_v
        bettar = miss_v
        veg = miss_v
        kd = miss_v

        lambd = miss_v
        organic = miss_v       
        FYM = miss_v        

        Temp = miss_v
        e = miss_v
        Rswd = miss_v
        Rlwd = miss_v
        p = miss_v
        pr = miss_v
        Wind = miss_v
        Tsrf = miss_v
        Tgr = miss_v
        snow = miss_v
        ra = miss_v
        Tsoil = miss_v
        Wsoil = miss_v
        Isoil = miss_v
        Evpar = miss_v
    end subroutine


end module environment_core
