module environment

    !< @brief блок расчета/чтения форсинга окружающей среды
    !< @details главный модуль, маршрутизация вызовов подпрограмм

    use environment_core, only : environment_core_init
    use environment_data_generator, only : environment_data_init_generator => environment_data_init, &
                                         & environment_data_calc_at_timestep_generator => environment_data_calc_at_timestep, &
                                         & environment_data_calc_at_cell_generator => environment_data_calc_at_cell, &
                                         & environment_data_calc_at_tile_generator => environment_data_calc_at_tile
    use environment_data_lsm_offline, only : environment_data_init_lsm_offline => environment_data_init, &
                                           & environment_data_calc_at_timestep_lsm_offline => environment_data_calc_at_timestep, &
                                           & environment_data_calc_at_cell_lsm_offline => environment_data_calc_at_cell, &
                                           & environment_data_calc_at_tile_lsm_offline => environment_data_calc_at_tile
    use environment_model_inmcm, only : environment_model_init_inmcm => environment_model_init, &
                                      & environment_model_calc_at_timestep_inmcm => environment_model_calc_at_timestep, &
                                      & environment_model_calc_at_cell_inmcm => environment_model_calc_at_cell, &
                                      & environment_model_calc_at_tile_inmcm => environment_model_calc_at_tile
    use environment_data_station, only : environment_data_init_station => environment_data_init, &
                                         & environment_data_calc_at_timestep_station => environment_data_calc_at_timestep, &
                                         & environment_data_calc_at_cell_station => environment_data_calc_at_cell, &
                                         & environment_data_calc_at_tile_station => environment_data_calc_at_tile									  
									  
									  
									  
    use config, only : environment_data_type, &
                     & environment_model_type
            
    implicit none

    private
    public :: environment_init
    public :: environment_calc_at_timestep
    public :: environment_calc_at_cell
    public :: environment_calc_at_tile	

    interface
        subroutine interface_init()
        end subroutine
        subroutine interface_calc_at_timestep()
        end subroutine
        subroutine interface_calc_at_cell(ii,jj)
            integer, intent(in) :: ii, jj
        end subroutine
        subroutine interface_calc_at_tile(ii,jj,nn)
            integer, intent(in) :: ii, jj, nn
        end subroutine
    end interface
    
    procedure(interface_init), pointer :: environment_data_init
    procedure(interface_calc_at_timestep), pointer :: environment_data_calc_at_timestep
    procedure(interface_calc_at_cell), pointer :: environment_data_calc_at_cell
    procedure(interface_calc_at_tile), pointer :: environment_data_calc_at_tile
    
    procedure(interface_init), pointer :: environment_model_init
    procedure(interface_calc_at_timestep), pointer :: environment_model_calc_at_timestep
    procedure(interface_calc_at_cell), pointer :: environment_model_calc_at_cell
    procedure(interface_calc_at_tile), pointer :: environment_model_calc_at_tile

contains


    subroutine environment_init()
    
        select case(environment_data_type)
            case('none')
                environment_data_init => dummy_init
                environment_data_calc_at_timestep => dummy_calc_at_timestep
                environment_data_calc_at_cell => dummy_calc_at_cell
                environment_data_calc_at_tile => dummy_calc_at_tile
            case('generator')
                environment_data_init => environment_data_init_generator
                environment_data_calc_at_timestep => environment_data_calc_at_timestep_generator
                environment_data_calc_at_cell => environment_data_calc_at_cell_generator
                environment_data_calc_at_tile => environment_data_calc_at_tile_generator
            case('lsm_offline')
                environment_data_init => environment_data_init_lsm_offline
                environment_data_calc_at_timestep => environment_data_calc_at_timestep_lsm_offline
                environment_data_calc_at_cell => environment_data_calc_at_cell_lsm_offline
                environment_data_calc_at_tile => environment_data_calc_at_tile_lsm_offline
       
			case('station')
                environment_data_init => environment_data_init_station
                environment_data_calc_at_timestep => environment_data_calc_at_timestep_station
                environment_data_calc_at_cell => environment_data_calc_at_cell_station
                environment_data_calc_at_tile => environment_data_calc_at_tile_station
        end select

    
        select case(environment_model_type)
            case('inmcm')
				select case(environment_data_type)
					case('none')
						environment_model_init => dummy_init
						environment_model_calc_at_timestep => dummy_calc_at_timestep
						environment_model_calc_at_cell => dummy_calc_at_cell
						environment_model_calc_at_tile => dummy_calc_at_tile
					case default
						environment_model_init => environment_model_init_inmcm
						environment_model_calc_at_timestep => environment_model_calc_at_timestep_inmcm
						environment_model_calc_at_cell => environment_model_calc_at_cell_inmcm
						environment_model_calc_at_tile => environment_model_calc_at_tile_inmcm
					end select
            case default
                environment_model_init => dummy_init
                environment_model_calc_at_timestep => dummy_calc_at_timestep
                environment_model_calc_at_cell => dummy_calc_at_cell
                environment_model_calc_at_tile => dummy_calc_at_tile
        end select
    
        call environment_core_init()
        
        call environment_data_init()
        
        call environment_model_init()
        
    end subroutine


        subroutine environment_calc_at_timestep()
        
        call environment_data_calc_at_timestep()
        
        call environment_model_calc_at_timestep()
        
    end subroutine


    subroutine environment_calc_at_cell(ii,jj)
    
        integer, intent(in) :: ii, jj
        
        call environment_data_calc_at_cell(ii,jj)
        
        call environment_model_calc_at_cell(ii,jj)
        
    end subroutine


    subroutine environment_calc_at_tile(ii,jj,nn)
    
        integer, intent(in) :: ii, jj, nn
        
        call environment_data_calc_at_tile(ii,jj,nn)
        
        call environment_model_calc_at_tile(ii,jj,nn)
        
    end subroutine
    
    
    
    ! пустышки для указателей
    
    subroutine dummy_init()
    end subroutine
    
    subroutine dummy_calc_at_timestep()
    end subroutine
    
    subroutine dummy_calc_at_cell(ii,jj)
        integer, intent(in) :: ii, jj
    end subroutine
    
    subroutine dummy_calc_at_tile(ii,jj,nn)
        integer, intent(in) :: ii, jj, nn
    end subroutine
    
end module
