
module const

    !> все константы

    implicit none

    ! ----------------------------------------------- Constant values ------------------------------------------------

    ! физические константы:
    real, parameter :: pi = 4.*atan(1.)         !< pi
    real, parameter :: w_day = 2.*pi/24.        !< угловая частота суточных колебаний, рад/ч
    real, parameter :: day2sec = 86400.         !< сутки в секунды
    real, parameter :: yrs = day2sec * 365.25   !< годы в секунды (примерно)
    real, parameter :: hPa2Pa = 100.            !< гектопаскали в паскали
    real, parameter :: bar2hPa = 1000.          !< бары в гектопаскали
    real, parameter :: cm2mm = 10.              !< сантиметры в миллиметры
    real, parameter :: m2cm = 100.              !< метры в сантиметры
    real, parameter :: umol2kg = 12.e-9         !< микромоли в килограммы углерода
    real, parameter :: Tf = 0.                  !< точка замерзания воды, С
    real, parameter :: Kelvin0 = 273.16         !< Температура замерзания воды, [K]
    real, parameter :: ppm2frac = 1.e-6         !<
    real, parameter :: r_earth = 6371000.       !< радиус Земли, м
    real, parameter :: rho_w = 1.               !< плотность воды [г/см3]
    real, parameter :: deg2rad = pi/180.
    integer, parameter :: nmonth = 12           !< количество месяцев в году

    ! технические константы:
    integer, parameter :: miss_v = -999         !< значение по умолчанию
    character(*), parameter :: miss_s = '---'   !< значение по умолчанию
    integer, parameter :: len_default = 100

    contains


        function esat(T)

            real :: esat
            real, intent(in) :: T  ! температура воздуха, C
            real, parameter :: e0 = 6.107
            real, parameter :: aw = 7.6326, bw = 241.9
            real, parameter :: ai = 9.5000, bi = 265.5
    
            if (T >= Tf) then
                esat = e0*10.**(aw*T/(T+bw))
            else
                esat = e0*10.**(ai*T/(T+bi))
            endif

        end function

        function q2e(q,p) result(e)

            real :: e
            real, intent(in) :: q, p
            real, parameter :: muv2mud = 0.622

            e = q*p/muv2mud
            
        ! real :: Ra, Rv, PPa
        ! Ra = 1000 * 6.0221367 * 1.380658 / 28.9644
        ! Rv = 1000 * 6.0221367 * 1.380658 / 18.0153
        ! PPa = p*100000.
        ! e = Rv*q*PPa/(Ra+q*(Rv-Ra))
        ! if (e>PPa) e = PPa*q

        end function

end module
