module config

    use const, only : len_default

    implicit none

    public
    private :: config_check
 ! конфигурация   
    character(len_default) :: carbon_model_type
	
 ! входные данные	
    character(len_default) :: environment_data_type
    character(len_default) :: lsm_datafile
    character(len_default) :: lsm_dataformat

	character(len_default) :: station_name
    character(len_default) :: station_opt
! пространственная сетка
    character(len_default) :: spatial_grid_mode
    real :: spatial_grid_res(2)
    character(len_default) :: spatial_sample_mode
    integer :: id
    integer :: ich
    real :: point(2)
    real :: polygon(4)
! продолжительность расчета
    character(len_default) :: dt_mode
    integer :: dt
    character(len_default) :: datetime_init_mode
    character(len_default) :: datetime_init
    character(len_default) :: ntime_mode
    integer :: ntime
    character(len_default) :: datetime_last
    integer :: UTC = 0
! продвинутые настройки
    logical :: if_datafile_read_at_first
    logical :: if_out_yearly
    logical :: if_standard_print
    logical :: if_standard_output
    character(len_default) :: testing_log_mode
    integer :: nv_singlecolumn
    character(len_default) :: environment_model_type
	


    namelist /config_namelist/ &
    & carbon_model_type, &
    & environment_data_type, &
    & lsm_datafile, &
    & lsm_dataformat, &
    &station_name, &
    &station_opt, &
    & spatial_grid_mode, &
    & spatial_grid_res, &
    & spatial_sample_mode, &
    & id, &
    & ich, &
    & point, &
    & polygon, &
    & dt_mode, &
    & dt, &
    & datetime_init_mode, &
    & datetime_init, &
    & ntime_mode, &
    & ntime, &
    & datetime_last, &
    & UTC, &
    & if_datafile_read_at_first, &
    & if_out_yearly, &
    & if_standard_print, &
    & if_standard_output, &
    & testing_log_mode, &
    & nv_singlecolumn, &
    & environment_model_type

    type namespace_type
        character(len_default) :: lon
        character(len_default) :: lat
        character(len_default) :: lev
        character(len_default) :: time
        character(len_default) :: mask
        character(len_default) :: us
        character(len_default) :: vs
        character(len_default) :: ta
        character(len_default) :: qa
        character(len_default) :: ps
        character(len_default) :: p
        character(len_default) :: rsw
        character(len_default) :: rlw
        character(len_default) :: tsrf1
        character(len_default) :: tgr
        character(len_default) :: s
        character(len_default) :: ga
        character(len_default) :: tsoil
        character(len_default) :: wsoil
        character(len_default) :: isoil
    end type
    type(namespace_type) :: nc_namespace
    
    contains
    
        subroutine config_init()
        
            open(1, file='ui1_config.nml', status='old')
            read(1, nml=config_namelist)
            close(1)
            
            call config_check()
            
            select case (lsm_dataformat)
                case('inmcm')
                    nc_namespace%lon   = 'lon'
                    nc_namespace%lat   = 'lat'
                    nc_namespace%lev   = 'lev'
                    nc_namespace%time  = 'time'
                    nc_namespace%us    = 'UPBL'
                    nc_namespace%vs    = 'VPBL'
                    nc_namespace%ta    = 'TPBL'
                    nc_namespace%qa    = 'QPBL'
                    nc_namespace%ps    = 'PGR'
                    nc_namespace%p     = 'PRECIP'
                    nc_namespace%rsw   = 'TABL2_SDWSW'
                    nc_namespace%rlw   = 'TABL2_SDWLW'
                    nc_namespace%tsrf1 = 'TSRFOL1'
                    nc_namespace%tgr   = 'TGROLD'
                    nc_namespace%s     = 'SNOLD'
                    nc_namespace%ga    = 'CTxAUS'
                    nc_namespace%tsoil = 'TO'
                    nc_namespace%wsoil = 'WLO'
                    nc_namespace%isoil = 'WIO'
                    nc_namespace%mask  = 'mask'
                    ! см также перевод единиц в environment_data_lsm_offline.f90
            end select
            
        end subroutine
        
        
        subroutine config_check()
        
            ! тест на доступные значения
            ! -----------------------------------------------------------------------------
        
            select case(carbon_model_type)
                case('inmcm', 'socs', 'other', 'rothc')
                case default
                    stop "check failed : unknown carbon_model_type"
            end select
            
            select case(environment_data_type)
                case('none', 'generator', 'lsm_offline', 'station')
                case('lsm_online')
                    stop "check failed : environment_data_type == 'lsm_online' is not supported yet"
                case default
                    stop "check failed : unknown environment_data_type"
            end select
			
			select case(station_name)
			    case('Rostov', 'DAO3','DAO4', 'VLDMR', 'TRGK')
                case default
                    stop "check failed : unknown station name"
            end select
			
			select case(station_opt)
			    case('1', '2','3', '4')
                case default
                    stop "check failed : unknown station_opt"
            end select
			
			
            
            select case(lsm_dataformat)
                case('inmcm')
                case('era5')
                    stop "check failed : lsm_dataformat == 'era5' is not supported yet"
                case default
                    stop "check failed : unknown lsm_dataformat"
             end select
            
            select case(spatial_grid_mode)
                case('none', 'auto', 'manual')
                case default
                    stop "check failed : unknown spatial_grid_mode"
            end select
            
            select case(spatial_sample_mode)
                case('id', 'ich', 'point', 'polygon', 'all')
                case default
                    stop "check failed : unknown spatial_sample_mode"
            end select
            
            select case(dt_mode)
                case('auto', 'manual')
                case default
                    stop "check failed : unknown dt_mode"
            end select
            
            select case(datetime_init_mode)
                case('auto', 'manual')
                case default
                    stop "check failed : unknown datetime_init_mode"
            end select
            
            select case(ntime_mode)
                case('auto', 'ntime', 'datetime_last')
                case default
                    stop "check failed : unknown ntime_mode"
            end select
            
            select case(testing_log_mode)
                case('none', 'write', 'read')
                case default
                    stop "check failed : unknown testing_log_mode"
            end select
            
            ! тест на сочетания настроек
            ! ----------------------------------------------------------------------------- 

            !if (carbon_model_type == 'socs' .and. environment_data_type == 'station' &
			!     & .and. (station_name == 'VLDMR' .or. station_name == 'TRGK' )) then 
            !    stop "check failed : this carbon_model_type can't work with this station name"
            !endif
            
            if ((station_name == 'Rostov' .or. station_name == 'VLDMR' .or. station_name == 'TRGK' ) .and. station_opt == '4') then 
                stop "check failed : this station name can't work with this station_opt"
            endif

            if (carbon_model_type == 'inmcm' .and. environment_data_type == 'none') then
                stop "check failed : carbon_model_type == 'inmcm' requires environment_data_type /= 'none'"
            endif
            
            if (carbon_model_type == 'inmcm' .and. spatial_grid_mode == 'none') then
                stop "check failed : carbon_model_type == 'inmcm' requires spatial_grid_mode /= 'none'"
            endif
            
            if (environment_data_type == 'lsm_offline' .and. spatial_grid_mode == 'none') then
                stop "check failed : environment_data_type == 'lsm_offline' requires spatial_grid_mode /= 'none'"
            endif
            
            if (spatial_sample_mode == 'auto' .and. environment_data_type /= 'lsm_offline') then
                stop "check failed : spatial_sample_mode == all' requires environment_data_type == 'lsm_offline'"
            endif
            
            if (dt_mode == 'auto' .and. environment_data_type /= 'lsm_offline') then
                stop "check failed : dt_mode == 'auto' requires environment_data_type == 'lsm_offline'"
            endif
            
            if (datetime_init_mode == 'auto' .and. environment_data_type /= 'lsm_offline') then
                stop "check failed : datetime_init_mode == 'auto' requires environment_data_type == 'lsm_offline'"
            endif
            
            if (ntime_mode == 'auto' .and. environment_data_type /= 'lsm_offline') then
                stop "check failed : ntime_mode == 'auto' requires environment_data_type == 'lsm_offline'"
            endif
        
        end subroutine
        
end module
