 
module carbon_solver

    ! интерфейс
    ! ---------------------------------------------------------------------------------

    private
    public :: carbon_solver_fluxes
    public :: carbon_solver_pools
 

contains


    ! внешние процедуры
    ! ---------------------------------------------------------------------------------

    subroutine carbon_solver_fluxes(ii,jj,nn)
        ! ---------------------------------------
        !< @brief расчет потоков по мультипликативной модели
        
        use grid, only : date_c
        use carbon_core, only : flux, nflux
        use carbon_model_to_core, only : get_mult
        
        integer, intent(in) :: ii, jj, nn
        
        integer :: f, m         !< array/loop index
        real :: mult, prod      !< service variables
        
        do f = 1, nflux
            prod = 1.
            do m = 1, flux(f)%nmult
                mult = get_mult(flux(f)%mult_kit(m))
                prod = prod * mult
            end do
            flux(f)%val(ii,jj,nn) = prod
        enddo
            
    end subroutine
    
    
    subroutine carbon_solver_pools(ii,jj, nn)
        ! ---------------------------------------
        !< @brief вычисление значений пулов на очередном шаге по времени
        
        use grid, only : dt
        use carbon_core, only : pool, flux, nflux
        
        integer, intent(in) :: ii, jj, nn

        integer :: n, m, f      !< array/loop index
        
        do f = 1, nflux
            n = flux(f)%pid_out
            m = flux(f)%pid_in
            pool(n)%val(ii,jj,nn) = pool(n)%val(ii,jj,nn) - flux(f)%val(ii,jj,nn) * dt
            pool(m)%val(ii,jj,nn) = pool(m)%val(ii,jj,nn) + flux(f)%val(ii,jj,nn) * dt
        enddo

    end subroutine

    
end module
