module carbon_model_socs_aux

    ! интерфейс
! ----------------------------------------------- Use pack ------------------------------------------------------------
	use environment_core, only: Tsoil, Wsoil, lambd, sw, kd 
	use config, only: station_name, station_opt, carbon_model_type
    use const,  only: yrs
    use grid,   only: date_c, i0, i1, j0, j1, ml
! ---------------------------------------------- Variables ------------------------------------------------------------
    implicit none

    ! ------- Pools -------
    real, dimension(:,:,:), pointer :: Catm   !< атмосфера
    real, dimension(:,:,:), pointer :: Cveg   !< растительность
    real, dimension(:,:,:), pointer :: C1     !< огранический углерод в почве / soil organic carbon (SOC)
    real, dimension(:,:,:), pointer :: C2     !< минерализованный углерод в почве / mineral organic carbon (MOC)
    ! ------- Flows -------
    real, dimension(:,:,:), pointer :: F_microbal_respiration  !< Между почвой1 и атмосферой (микробное дыхание)
    real, dimension(:,:,:), pointer :: F_litterfall            !< Между растением и почвой1 (отмирание и опад)
    real, dimension(:,:,:), pointer :: F_mineralization        !< Между почвой1 и почвой2 (минерализация)
    real, dimension(:,:,:), pointer :: F_destabilization       !< Между почвой2 и почвой1 (дестабилизация?)
    ! ------- Serve value -------
    integer, parameter :: ntiles = 2   !< В данном случае, количество пулов
    ! ------- Functions ------------
    real :: Ft, Fs                     !< Функции: температуры, влажности [dim]
    ! ------ Climate variables --------
    ! ------ Determined within
    real, allocatable :: s0(:,:,:)           !< Оптимальная влажность почвы, [dim]
    real, allocatable :: smin(:,:,:)         !< Переменные для функций, [dim]
    ! ------- Coefficients ------------	
    real :: rare = 0.45      !< Доля углерода переходящего в пул защищенного C1
    real :: Cm = 12.         !< Max кол-во органического углерода которое может быть защищено в почве
    real :: kirk = 0.        !< Коэф. скорости разложения C1
	!real :: kd               !< Коэф. перехода углерода из C2 в C1, десорбация, разрушение агрегатов
    real, allocatable :: C_atm1(:,:,:) , C_atm2(:,:,:) 

contains

    subroutine carbon_model_init()

      integer :: i !< count

      allocate(C_atm1(i0:i1,j0:j1,ml))
      allocate(C_atm2(i0:i1,j0:j1,ml))

      allocate(s0(i0:i1,j0:j1,ml))
      allocate(smin(i0:i1,j0:j1,ml))

      do i = 1, ml
        s0  (:,:,i) = 0.5*(1. + sw(:,:))
        smin(:,:,i) = 1.7*sw(:,:)
      end do

    end subroutine



    subroutine carbon_model_calc_at_timestep()


    end subroutine



    subroutine carbon_model_calc_at_cell(ii,jj)

      integer, intent(in) :: ii, jj


    end subroutine



    subroutine carbon_model_calc_at_tile(ii,jj,nn)

      integer, intent(in) :: ii, jj, nn

      if (Wsoil(ii,jj,1) >= s0(ii,jj,1)) then
        Fs = 1. - 0.8*(Wsoil(ii,jj,1) - s0(ii,jj,1))
      else if (smin(ii,jj,1) < Wsoil(ii,jj,1) .and. Wsoil(ii,jj,1) < s0(ii,jj,1)) then
        Fs = 0.2 + 0.8*(Wsoil(ii,jj,1) - smin(ii,jj,1))/(s0(ii,jj,1) - smin(ii,jj,1))
      else if (Wsoil(ii,jj,1) <= smin(ii,jj,1)) then
        Fs = 0.2
      end if

      if (Tsoil(ii,jj,1) >= -18.27) then
        Ft = 47.91/(1. + exp(106.06/(Tsoil(ii,jj,1) + 18.27)))
      else
        Ft = 0
      end if

      !kirk = 7.5/yrs     
      kirk = Ft*Fs*7.5/yrs  !7.5
      !print*, kirk

    end subroutine



    subroutine carbon_model_postprocessing()

	use grid, only : date_c

      open(unit=500, file='results/'//trim(carbon_model_type)//'/'//trim(station_name)//'_'//trim(station_opt)//'.txt', status='unknown')
      write(500,*) date_c%timestamp,';',C1(:,:,1),';',C2(:,:,1) 

	end subroutine

end module