module carbon_model_socs

    !< @brief модель углеродного цикла SOCS (модель почвоведов)

! интерфейс
! ----------------------------------------------------------------------

    use carbon_model_to_core, only : set_tiles, set_pool, set_flux, set_mult
    use carbon_model_socs_aux

    implicit none

    private
    public :: carbon_model_assembly

    contains


        subroutine carbon_model_assembly()

            integer :: n_Catm, n_Cveg, n_Csoil1, n_Csoil2   !< id пулов
            integer :: n_F                                  !< id потока

            call set_tiles(ntiles)

            call set_pool(pid = n_Catm,   name = 'catm')
            call set_pool(pid = n_Cveg,   name = 'cveg')
            call set_pool(pid = n_Csoil1, name = 'csoil1',initial_value = 0.060888, alias = C1)
            call set_pool(pid = n_Csoil2, name = 'csoil2',initial_value = 2.983512, alias = C2)

!        station: opt: С1:        С2:
!        DAO4     1    0.061994   3.037706
!                 2    0.064774   3.173926
!                 3    0.064496   3.160304
!                 4    0.060882   2.983218
!        DAO3     1    0.05676    2.78124
!                 2    0.057276   2.806524
!                 3    0.060888   2.983512
!                 4    0.060028   2.941372
!        TRGK     1    0.0619416  3.0351384
!                 2    0.0569418  2.7901482
!                 3    0.0619416  3.0351384
!        VLDR     1    0.0338432  1.6583168
!        ROST     1    0.178176   8.730624
            call set_flux(fid = n_F, pid_out = n_Cveg, pid_in = n_Csoil1, name = 'litterfall')
            call set_mult(n_F, 'lin', x_ij = lambd)

            call set_flux(fid = n_F, pid_out = n_Csoil2, pid_in = n_Csoil1, name = 'destabilization')
            call set_mult(n_F, 'lin', x_ijn = C2)
            call set_mult(n_F, 'lin', x_ij = kd)            

            call set_flux(fid = n_F, pid_out = n_Csoil1, pid_in = n_Csoil2, name = 'mineralization')
            call set_mult(n_F, 'lin', x_ijn = C2, k = -1./Cm, y0 = 1.)
            call set_mult(n_F, 'const', c = rare)
            call set_mult(n_F, 'lin', x = kirk)
            call set_mult(n_F, 'lin', x_ijn = C1)

            call set_flux(fid = n_F, pid_out = n_Csoil1, pid_in = n_Catm, name = 'microbal_respiration')
            call set_mult(n_F, 'lin', x_ijn = C1, k = (1. - rare))
            call set_mult(n_F, 'lin', x = kirk)

        end subroutine carbon_model_assembly


end module
