module carbon_model_rothc

    use carbon_model_to_core, only : set_tiles, set_pool, set_flux, set_mult
    use carbon_model_rothc_aux

    implicit none

    private
    public :: carbon_model_assembly

    contains


        subroutine carbon_model_assembly()

            integer :: n_Catm, n_Cveg, n_CDPM, n_CRPM, n_CBIO, n_CHUM, n_CIOM  !< id пулов
            integer :: n_F  !< id потока

            call set_tiles(ntiles)

            call set_pool(pid = n_Catm, name = 'catm')
            call set_pool(pid = n_Cveg, name = 'cveg')
            call set_pool(pid = n_CDPM, name = 'CDPM', initial_value = 0.02037, alias = CDPM)
            call set_pool(pid = n_CRPM, name = 'CRPM', initial_value = 1.75515, alias = CRPM)
            call set_pool(pid = n_CBIO, name = 'CBIO', initial_value = 0.06464, alias = CBIO)
            call set_pool(pid = n_CHUM, name = 'CHUM', initial_value = 1.14567, alias = CHUM)
            call set_pool(pid = n_CIOM, name = 'CIOM', initial_value = 0.257,  alias = CIOM)

!        station: opt: CDPM:     CRPM:   CBIO:    CHUM:    CIOM:
!        DAO4     1    0.01944  1.73544  0.06188  1.0416   0.245
!                 2    0.02037  1.75515  0.06464  1.14567  0.257
!                 3    0.02037  1.75515  0.06464  1.14567  0.257
!                 4    0.0192   1.73087  0.0612   1.01558  0.24

!        DAO3     1    0.01792  1.10183  0.05705  1.45947  0.221
!                 2    0.01792  1.10183  0.05705  1.45947  0.224
!                 3    0.01804  1.10426  0.05741  1.47248  0.225
!                 4    0.01792  1.10183  0.05705  1.45947  0.223

!        TRGK     1    0.02132  1.12986  0.05946  1.64844  0.238
!                 2    0.0196   1.08615  0.05455  1.46279  0.224
!                 3    0.02132  1.12986  0.05946  1.64844  0.238
!        VLDR     1    0.00777  1.38303  0.03275  0.14961  0.119
!        ROST     1    0.04936  0.799    0.11873  7.07025  0.814

            ! litterfall
            call set_flux(fid = n_F, pid_out = n_Cveg, pid_in = n_CDPM, name = 'fdpm*organic')
            call set_mult(n_F, 'lin', x_ij = organic, k = fdpm)
            
            call set_flux(fid = n_F, pid_out = n_Cveg, pid_in = n_CRPM, name = '(1-fdpm)*organic')
            call set_mult(n_F, 'lin', x_ij = organic, k = (1 - fdpm))
            
            call set_flux(fid = n_F, pid_out = n_Cveg, pid_in = n_CRPM, name = '0.49*FYM')
            call set_mult(n_F, 'lin', x_ij = FYM, k = fdpm2)
      
            call set_flux(fid = n_F, pid_out = n_Cveg, pid_in = n_CRPM, name = '0.49*FYM')
            call set_mult(n_F, 'lin', x_ij = FYM, k = fdpm2)

            call set_flux(fid = n_F, pid_out = n_Cveg, pid_in = n_CHUM, name = '0.02*FYM')
            call set_mult(n_F, 'lin', x_ij = FYM, k = 1. - 2*fdpm2)

            ! to atmosphere
            call set_flux(fid = n_F, pid_out = n_CDPM, pid_in = n_Catm, name = 'RDPM')
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(1))
            call set_mult(n_F, 'lin', x_ijn = CDPM)


            !call set_mult(n_F, 'const', c_n = 47.91)
            !call set_mult(n_F, 'exp',   x_ij = Tsoil, a = exp, k = 106.06, x0 = -18.27, y0 = 1.)
            !call set_mult(n_F, 'step',  x_ij = Tsoil, x0 = -4.99)


            call set_flux(fid = n_F, pid_out = n_CRPM, pid_in = n_Catm, name = 'RRPM')
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(2))
            call set_mult(n_F, 'lin', x_ijn = CRPM)

            call set_flux(fid = n_F, pid_out = n_CBIO, pid_in = n_Catm, name = 'RBIO')
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(3))
            call set_mult(n_F, 'lin', x_ijn = CBIO)

            call set_flux(fid = n_F, pid_out = n_CHUM, pid_in = n_Catm, name = 'RHUM')
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(4))
            call set_mult(n_F, 'lin', x_ijn = CHUM)

            ! atmosphere fall
            call set_flux(fid = n_F, pid_out = n_Catm, pid_in = n_CBIO, name = 'BIO_prop*RDPM')
            call set_mult(n_F, 'lin', x_ij = BIO_prop)
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(1))
            call set_mult(n_F, 'lin', x_ijn = CDPM)
            
            call set_flux(fid = n_F, pid_out = n_Catm, pid_in = n_CBIO, name = 'BIO_prop*RRPM')
            call set_mult(n_F, 'lin', x_ij = BIO_prop)
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(2))
            call set_mult(n_F, 'lin', x_ijn = CRPM)
            
            call set_flux(fid = n_F, pid_out = n_Catm, pid_in = n_CBIO, name = 'BIO_prop*RBIO')
            call set_mult(n_F, 'lin', x_ij = BIO_prop)
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(3))
            call set_mult(n_F, 'lin', x_ijn = CBIO)

            call set_flux(fid = n_F, pid_out = n_Catm, pid_in = n_CBIO, name = 'BIO_prop*RHUM')
            call set_mult(n_F, 'lin', x_ij = BIO_prop)
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(4))
            call set_mult(n_F, 'lin', x_ijn = CHUM)


            call set_flux(fid = n_F, pid_out = n_Catm, pid_in = n_CHUM, name = 'HUM_prop*RDPM')
            call set_mult(n_F, 'lin', x_ij = HUM_prop)
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(1))
            call set_mult(n_F, 'lin', x_ijn = CDPM)

            call set_flux(fid = n_F, pid_out = n_Catm, pid_in = n_CHUM, name = 'HUM_prop*RRPM')
            call set_mult(n_F, 'lin', x_ij = HUM_prop)
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(2))
            call set_mult(n_F, 'lin', x_ijn = CRPM)

            call set_flux(fid = n_F, pid_out = n_Catm, pid_in = n_CHUM, name = 'HUM_prop*RBIO')
            call set_mult(n_F, 'lin', x_ij = HUM_prop)
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(3))
            call set_mult(n_F, 'lin', x_ijn = CBIO)

            call set_flux(fid = n_F, pid_out = n_Catm, pid_in = n_CHUM, name = 'HUM_prop*RHUM')
            call set_mult(n_F, 'lin', x_ij = HUM_prop)
            call set_mult(n_F, 'lin', x = Ft)
            call set_mult(n_F, 'lin', y0 = 0.6, k = -0.4, x_ij = veg, x0 = 1.)
            call set_mult(n_F, 'lin', x = Fs)
            call set_mult(n_F, 'lin', x = ks(4))
            call set_mult(n_F, 'lin', x_ijn = CHUM)

        end subroutine carbon_model_assembly

end module