module carbon_model_inmcm

    !< @brief модель углеродного цикла inmcm

    ! интерфейс
    ! ---------------------------------------------------------------------------------

    use carbon_model_to_core, only : set_tiles, set_pool, set_flux, set_mult
    use carbon_model_inmcm_aux

    implicit none

    private
    public :: carbon_model_assembly


contains


    ! внешние процедуры
    ! ---------------------------------------------------------------------------------

    subroutine carbon_model_assembly()

        use environment_model_inmcm, only : nv2, vegg_nv2
        !use environment_core,        only : Tsoil
        use const,                   only : yrs, umol2kg
        use grid,                    only : ms

        integer :: n_Catm, n_Cveg, n_Csoil, n_Csoilb   !< id пулов
        integer :: n_F                                 !< id потока

        call set_tiles(nv2, vegg_nv2)

        call set_pool(pid = n_Catm,   name = 'catm'                                             )
        call set_pool(pid = n_Cveg,   name = 'cveg'   ,                          alias = Cveg   )
        call set_pool(pid = n_Csoil,  name = 'csoil'  ,initial_value = 2.983218, alias = Csoil  )
        call set_pool(pid = n_Csoilb, name = 'csoilb' ,initial_value = 0.060882, alias = Csoilb )

!        station: opt: С1:        С2:
!        ROST     1    8.730624   0.178176
!        VLDR     1    1.61406    0.03294
!        TRGK     1    3.10072    0.06328
!                 2    2.7901482  0.0569418
!                 3    2.93608    0.05992
!        DAO3     1    2.78124    0.05676
!                 2    2.806524   0.057276
!                 3    2.983512   0.060888
!                 4    2.941372   0.060028
!        DAO4     1    3.037706   0.061994   
!                 2    3.173926   0.064774   
!                 3    3.160304   0.064496   
!                 4    2.983218   0.060882   

        call set_flux(fid = n_F, pid_out = n_Csoil, pid_in = n_Catm, name = 'fmicr', alias = Fmicr)
        call set_mult(n_F, 'lin',   x_ijn = Csoil)
        call set_mult(n_F, 'const', c_n = amrp(:) * umol2kg)
        call set_mult(n_F, 'exp',   x_ij = Tsoil(:,:,ms+1), a = 2., k = 0.1, x0 = t_ref_soil)
        call set_mult(n_F, 'step',  x_ij = Tsoil(:,:,ms+1), x0 = tmin_soil, k = 0.5, y0 = 0.5)
        call set_mult(n_F, 'mm',    x_n = rsw, k = 1.,   x0 = -0.20)
        call set_mult(n_F, 'hyp',   x_n = rsw, k = 0.23, x0 = -0.23)
        call set_mult(n_F, 'const', c = 1.5)

        call set_flux(fid = n_F, pid_out = n_Csoilb, pid_in = n_Catm, name = 'fmicrb', alias = Fmicrb)
        call set_mult(n_F, 'lin',   x_ijn = Csoilb)
        call set_mult(n_F, 'const', c_n = amrp(:) * umol2kg)
        call set_mult(n_F, 'exp',   x_ij = Tsoil(:,:,ms+1), a = 2., k = 0.1, x0 = t_ref_soil)
        call set_mult(n_F, 'step',  x_ij = Tsoil(:,:,ms+1), x0 = tmin_soil, k = 0.5, y0 = 0.5)
        call set_mult(n_F, 'mm',    x_n = rsw, k = 1.,   x0 = -0.20)
        call set_mult(n_F, 'hyp',   x_n = rsw, k = 0.23, x0 = -0.23)
        call set_mult(n_F, 'const', c = 1.5)
        call set_mult(n_F, 'const', c = cv81b)

        call set_flux(fid = n_F, pid_out = n_Cveg, pid_in = n_Csoil, name = 'dv68', alias = Flit)
        call set_mult(n_F, 'lin', x_ij = lambd)

        call set_flux(fid = n_F, pid_out = n_Csoil, pid_in = n_Csoilb, name = 'ddc8', alias = Fers)
        call set_mult(n_F, 'lin', x_ijn = ers_weight, k = landuseErs)

    end subroutine carbon_model_assembly

end module
