
module carbon_model_to_core_par_kit

    !< @brief обработка параметров мультипликативных функций
    
    ! интерфейс
    ! ---------------------------------------------------------------------------------
    
    use carbon_core, only : par_kit_type, npar_default
    
    implicit none
    
    private
    public :: set_pars
    public :: get_pars
    
    ! параметры
    ! ---------------------------------------------------------------------------------
    
    real, parameter :: y0_default = 0.
    real, parameter :: x0_default = 0.
    real, parameter :: k_default = 1.
    real, parameter :: a_default = exp(1.)
    real, parameter :: amp_default = 1.
    
    
contains


    ! внешние процедуры
    ! ---------------------------------------------------------------------------------
    
    subroutine set_pars(par_kit, &
                       & c, c_n, c_ij, &
                       & y0, y0_n, y0_ij, &
                       & x0, x0_n, x0_ij, &
                       & k, k_n, k_ij, &
                       & a, a_n, a_ij, &
                       & amp, amp_n, amp_ij)
        ! ---------------------------------------
        !< @brief установка вида функций и их параметров
        
        use const, only : miss_v
        use grid, only : i0, i1, j0, j1
        use carbon_core, only : ntile
        
        type(par_kit_type), intent(inout) :: par_kit(npar_default)
        !> перечень возможных параметров:
        real, optional, intent(in) :: c, c_n(ntile), c_ij(i0:i1,j0:j1)
        real, optional, intent(in) :: y0, y0_n(ntile), y0_ij(i0:i1,j0:j1)
        real, optional, intent(in) :: x0, x0_n(ntile), x0_ij(i0:i1,j0:j1)
        real, optional, intent(in) :: k, k_n(ntile), k_ij(i0:i1,j0:j1)
        real, optional, intent(in) :: a, a_n(ntile), a_ij(i0:i1,j0:j1)
        real, optional, intent(in) :: amp, amp_n(ntile), amp_ij(i0:i1,j0:j1)
        
        integer :: n
        
        do n = 1, npar_default
            allocate(par_kit(n)%par2(ntile))
            allocate(par_kit(n)%par3(i0:i1,j0:j1))
            par_kit(n)%par1 = miss_v
            par_kit(n)%par2 = miss_v
            par_kit(n)%par3 = miss_v
        enddo
        
        ! par_kit(1) - y0 или c
        ! par_kit(2) - x0
        ! par_kit(3) - k
        ! par_kit(4) - a
        ! par_kit(5) - amp
        
        if (present(y0)) then
            par_kit(1)%par1 = y0
            par_kit(1)%num = 1
        elseif (present(y0_n)) then
            par_kit(1)%par2 = y0_n
            par_kit(1)%num = 2
        elseif (present(y0_ij)) then
            par_kit(1)%par3 = y0_ij
            par_kit(1)%num = 3
        elseif (present(c)) then
            par_kit(1)%par1 = c
            par_kit(1)%num = 1
        elseif (present(c_n)) then
            par_kit(1)%par2 = c_n
            par_kit(1)%num = 2
        elseif (present(c_ij)) then
            par_kit(1)%par3 = c_ij
            par_kit(1)%num = 3
        else
            par_kit(1)%par1 = y0_default
            par_kit(1)%num = 1
        endif
        
        if (present(x0)) then
            par_kit(2)%par1 = x0
            par_kit(2)%num = 1
        elseif (present(x0_n)) then
            par_kit(2)%par2 = x0_n
            par_kit(2)%num = 2
        elseif (present(x0_ij)) then
            par_kit(2)%par3 = x0_ij
            par_kit(2)%num = 3
        else
            par_kit(2)%par1 = x0_default
            par_kit(2)%num = 1
        endif
        
        if (present(k)) then
            par_kit(3)%par1 = k
            par_kit(3)%num = 1
        elseif (present(k_n)) then
            par_kit(3)%par2 = k_n
            par_kit(3)%num = 2
        elseif (present(k_ij)) then
            par_kit(3)%par3 = k_ij
            par_kit(3)%num = 3
        else
            par_kit(3)%par1 = k_default
            par_kit(3)%num = 1
        endif
        
        if (present(a)) then
            par_kit(4)%par1 = a
            par_kit(4)%num = 1
        elseif (present(a_n)) then
            par_kit(4)%par2 = a_n
            par_kit(4)%num = 2
        elseif (present(a_ij)) then
            par_kit(4)%par3 = a_ij
            par_kit(4)%num = 3
        else
            par_kit(4)%par1 = a_default
            par_kit(4)%num = 1
        endif
        
        if (present(amp)) then
            par_kit(5)%par1 = amp
            par_kit(5)%num = 1
        elseif (present(amp_n)) then
            par_kit(5)%par2 = amp_n
            par_kit(5)%num = 2
        elseif (present(amp_ij)) then
            par_kit(5)%par3 = amp_ij
            par_kit(5)%num = 3
        else
            par_kit(5)%par1 = amp_default
            par_kit(5)%num = 1
        endif
        
    end subroutine


    function get_pars(par_kit, ii, jj, nn, month, year) result (pars)
        ! ---------------------------------------
        type(par_kit_type), intent(in) :: par_kit(npar_default)
        integer, intent(in) :: ii
        integer, intent(in) :: jj
        integer, intent(in) :: nn
        integer, intent(in) :: month
        integer, intent(in) :: year
        
        real :: pars(npar_default)
        integer :: n
        
        do n = 1, npar_default
                select case(par_kit(n)%num)
                case(1)
                    pars(n) = par_kit(n)%par1
                case(2)
                    pars(n) = par_kit(n)%par2(nn)
                case(3)
                    pars(n) = par_kit(n)%par3(ii,jj)
                end select
        enddo
        
    end function


end module
