
module carbon_model_to_core_arg_kit

    !< @brief обработка аргументов мультипликативных функций

    ! интерфейс
    ! ---------------------------------------------------------------------------------

    use carbon_core, only: arg_kit_type, narg_default
    use grid,        only: date_c, date_fst, date_lst,first_date,last_date
    implicit none

    private
    public :: set_args
    public :: get_args
    public :: year_min, year_max, nmonth

    ! параметры
    ! ---------------------------------------------------------------------------------

    integer :: fix1, fix2

    integer, parameter :: nmonth = 12

    integer, parameter :: year_min = 1900      !< предусмотренный диапазон лет @todo прописать allocatable, т.к. требуется для типа переменной x_year, иначе ошибка
    integer, parameter :: year_max = 2025      !<
	
    ! (44)*12 = 528 ! Для случая Rostov:  1975 - 2018
    ! (73)*12 = 876 ! Для случая DAO3:    1939 - 2012
    ! (75)*12 = 900 ! Для случая DAO4:    1937 - 2012
    ! (62)*12 = 744 ! Для случая TRGK:    1956 - 2018
    ! (50)*12 = 600 ! Для случая VLDMR:   1968 - 2018

contains


    ! внешние процедуры
    ! ---------------------------------------------------------------------------------

    subroutine set_args(arg_kit, &
                      & x, x_n, x_ij, x_ijn, x_ijn_month, x_year)
        ! ---------------------------------------
        !< @brief установка аргументов

        use const, only : miss_v
        use grid, only : i0, i1, j0, j1
        use carbon_core, only : ntile

        type(arg_kit_type), intent(inout) :: arg_kit(narg_default)
        !> перечень возможных аргументов:
        real, optional, intent(in), target :: x
        real, optional, intent(in), target :: x_n(ntile)
        real, optional, intent(in), target :: x_ij(i0:i1,j0:j1)
        real, optional, intent(in), target :: x_ijn(i0:i1,j0:j1,ntile)
        real, optional, intent(in), target :: x_ijn_month(i0:i1,j0:j1,ntile,nmonth)
        real, optional, intent(in), target :: x_year(year_min:year_max)

        integer :: n
        integer :: mnc !< Количество месяцев в расчете

        do n = 1, narg_default
            allocate(arg_kit(n)%arg1)
            allocate(arg_kit(n)%arg2(ntile))
            allocate(arg_kit(n)%arg3(i0:i1,j0:j1))
            allocate(arg_kit(n)%arg4(i0:i1,j0:j1,ntile))
            allocate(arg_kit(n)%arg5(i0:i1,j0:j1,ntile,nmonth))
            allocate(arg_kit(n)%arg6(year_min:year_max))
            arg_kit(n)%arg1 = miss_v
            arg_kit(n)%arg2 = miss_v
            arg_kit(n)%arg3 = miss_v
            arg_kit(n)%arg4 = miss_v
            arg_kit(n)%arg5 = miss_v
            arg_kit(n)%arg6 = miss_v
        enddo

        ! arg_kit(1) - x

        if (present(x)) then
            arg_kit(1)%arg1 => x
            arg_kit(1)%num = 1
        elseif (present(x_n)) then
            arg_kit(1)%arg2 => x_n
            arg_kit(1)%num = 2
        elseif (present(x_ij)) then
            arg_kit(1)%arg3 => x_ij
            arg_kit(1)%num = 3
        elseif (present(x_ijn)) then
            arg_kit(1)%arg4 => x_ijn
            arg_kit(1)%num = 4
        elseif (present(x_ijn_month)) then
            arg_kit(1)%arg5 => x_ijn_month
            arg_kit(1)%num = 5
        elseif (present(x_year)) then
            arg_kit(1)%arg6 => x_year
            arg_kit(1)%num = 6
        else
            arg_kit(1)%arg1 = miss_v
            arg_kit(1)%num = 1  !  для const
        end if

    end subroutine


    function get_args(arg_kit, ii, jj, nn, month, year) result (args)
        ! ---------------------------------------
        type(arg_kit_type), intent(in) :: arg_kit(narg_default)
        integer, intent(in) :: ii
        integer, intent(in) :: jj
        integer, intent(in) :: nn
        integer, intent(in) :: month
        integer, intent(in) :: year

        real :: args(narg_default)
        integer :: n

        do n = 1, narg_default
            select case(arg_kit(n)%num)
                case(1)
                    args(n) = arg_kit(n)%arg1
                case(2)
                    args(n) = arg_kit(n)%arg2(nn)
                case(3)
                    args(n) = arg_kit(n)%arg3(ii,jj)
                case(4)
                    args(n) = arg_kit(n)%arg4(ii,jj,nn)
                case(5)
                    args(n) = arg_kit(n)%arg5(ii,jj,nn,month)
                case(6)
                    args(n) = arg_kit(n)%arg6(year)
            end select
        enddo

    end function


end module
