
module carbon_core

    !< @brief ядро модели углеродного цикла

    ! интерфейс
    ! ---------------------------------------------------------------------------------
    
    use const, only : len_default
    
    implicit none
    
    public
    
    ! параметры
    ! ---------------------------------------------------------------------------------

    integer, parameter :: npool_default = 10    !< макс число пулов
    integer, parameter :: nflux_default = 20    !< макс число потоков
    integer, parameter :: nmult_default = 10    !< макс число множителей в выражении для потока
    integer, parameter :: narg_default = 1      !< макс число аргументов функций в множителях
    integer, parameter :: npar_default = 5      !< макс число параметров функций в множителях
    
    ! производные типы данных
    ! ---------------------------------------------------------------------------------
    
    abstract interface
        function fun_interface(args, pars) result(y)
            import :: narg_default, npar_default
            implicit none
            real, intent(in) :: args(narg_default)
            real, intent(in) :: pars(npar_default)
            real :: y
        end function
    end interface

    type fun_kit_type
        procedure(fun_interface), pointer, nopass :: fun
    end type
    
    type arg_kit_type
        real, pointer :: arg1
        real, pointer :: arg2(:)
        real, pointer :: arg3(:,:)
        real, pointer :: arg4(:,:,:)
        real, pointer :: arg5(:,:,:,:)
        real, pointer :: arg6(:)
        integer :: num
    end type
    
    type par_kit_type
        real              :: par1
        real, allocatable :: par2(:)
        real, allocatable :: par3(:,:)
        integer :: num
    end type
    
    type mult_kit_type
        type(arg_kit_type) :: arg_kit(narg_default)
        type(par_kit_type) :: par_kit(npar_default)
        type(fun_kit_type) :: fun_kit
    end type
        
    type pool_type
        character(len_default) :: name
        real, allocatable :: val(:,:,:)
    end type
    
    type flux_type
        character(len_default) :: name
        real, allocatable :: val(:,:,:)
        integer :: pid_out
        integer :: pid_in
        integer :: nmult
        type(mult_kit_type) :: mult_kit(nmult_default)
    end type
    
    ! переменные
    ! ---------------------------------------------------------------------------------

    integer :: npool
    integer :: nflux
    type(pool_type), target :: pool(npool_default)
    type(flux_type), target :: flux(nflux_default)

    integer :: ntile = 1
    real, allocatable :: tile_weight(:,:,:)
    
    
end module
