program nonlin

    implicit none
! ----------------------------------------------- Variables -----------------------------------------------------------
! общие переменные
    integer :: i,j                !< count
	integer, parameter :: N = 10  ! количество элементов сетки 1
	integer, parameter :: M = 75  ! количество элементов сетки 2
! Величины для шага по сетке
    real :: z(0:N)                ! Уровень сетки 1 (глубина)
	real :: zh(0:N+1)              ! Значение аргумента, промежуточное значение уровня сетки, аналог x(i-1/2) в статье
    
    integer :: t                  ! Уровень сетки 2 (время)
    real :: dt = 10.               ! Шаг сетки 2 (Шаг по времени)
	real :: h  (N+1)              ! Шаг сетки 1 (общий вид)
    real :: dz (N+1)              ! Шаг сетки 1 (основной шаг)
    real :: dzh(N+1)              ! Шаг сетки 1 (промежуточный шаг)

! Внешняя функция, и её усреднение
    real :: U                   ! Оригинальное значение поступающей функции
    real :: c0 = 0.3              ! начальное значение функции
    real :: w = 0.00005              ! const функции

	real(kind = 8) :: Us(0:N)             ! Среднее значение функции (функция разбивается на небольшие интервалы)
    real(kind = 8) :: InU                 ! Интеграл от поступающей из вне функции
    
    real(kind = 8) :: Flux(0:N)
    real(kind = 8) :: C(0:N)

! Коэффициенты для финального вычисления, вычисления реконструкции слева и справа
    real :: M10(2:N), M10p1(2:N), M10p2(2:N) ! Коэффициент С10 и его составляющие
    real :: M11(2:N), M11p1(2:N), M11p2(2:N) ! Коэффициент С11 и его составляющие
    real :: M12(2:N), M12p1(2:N), M12p2(2:N) ! Коэффициент С12 и его составляющие
	
    real :: M00p1(N-1), M00p2(N-1), M00(N-1)       ! Коэффициент С00 и его составляющие
    real :: M01p1(N-1), M01p2(N-1), M01(N-1)       ! Коэффициент С01 и его составляющие
    real :: M02p1(N-1), M02p2(N-1), M02(N-1)       ! Коэффициент С02 и его составляющие

! Финальное вычисление, реконструкция слева и справа
    real :: Cz(2:N) ! Универсальная реконструкция
! ----------------------------------------------- Main programm -------------------------------------------------------
    ! ---- Initial value ----
    z = 0.
    zh = 0.
    h = 0.

    t = 0

    InU = 0.
    U = 0.
    Us(:) = 0.
    Cz(:) = 0.

    ! ---- Вычисление аргумента сетки, шага по сетке ----
    z(:) = (/0.,1.,2.,3.,4.,5.,6.,7.,8.,9.,10./)
    do i = 1, N
      z(i)  = (i/5.)**2 
      zh(i) = (z(i-1) + z(i))/2
    end do  
      zh(0) = z(0) !=0
      zh(N+1) = z(N)

    dzh(1) = abs(zh(1) - z(0))
    do i = 2, N
      dzh(i) = abs(zh(i) - zh(i-1))
    end do 
    dzh(N+1) = abs(z(N) - zh(N))

    h(:) = dzh(:)

      ! Вычисление коэффициентов при значениях среднего значения функции C(zh,t)
      do i = 2, N !M10, M11, M12
        M10p1(i) = -h(i)*h(i+1)
        M10p2(i) = (h(i) + h(i-1))*(h(i) + h(i-1) + h(i+1))
        M10(i) = M10p1(i)/M10p2(i)

        M11p1(i) = h(i+1)*(3*h(i)**2 + 3*h(i)*h(i-1) + 2*h(i)*h(i+1) + h(i-1)**2 + h(i-1)*h(i+1))
        M11p2(i) = (h(i)**2 + h(i)*h(i-1) + 2*h(i)*h(i+1) + h(i-1)*h(i+1) + h(i+1)**2)*(h(i) + h(i-1))
        M11(i) = M11p1(i)/M11p2(i)

        M12p1(i) = h(i)*(h(i) + h(i-1))
        M12p2(i) = h(i)**2 + h(i)*h(i-1) + 2*h(i)*h(i+1) + h(i-1)*h(i+1) + h(i+1)**2
        M12(i) = M12p1(i)/M12p2(i)
      end do

      do i = 1, N-1 !M00, M01, M02
        M00p1(i) = h(i+1)*(h(i+1) + h(i+2))
        M00p2(i) = (h(i) + h(i+1) + h(i+2))*(h(i) + h(i+1))
        M00(i) = M00p1(i)/M00p2(i)

        M01p1(i) = h(i)*(h(i+1) + h(i+2))/((h(i) + h(i+1))*h(i+2))
        M01p2(i) = h(i)*(h(i+1)**2)/(h(i+2)*(h(i) + h(i+1) + h(i+2))*(h(i+1) + h(i+2)))
        M01(i) = M01p1(i) - M01p2(i)

        M02p1(i) = - h(i)*h(i+1)
        M02p2(i) = (h(i) + h(i+1) + h(i+2))*(h(i+1) + h(i+2))
        M02(i) = M02p1(i)/M02p2(i)
      end do

      do i = 1, N
        U = C0*(100.*zh(i) - w*t)
        InU = U*0.5*(zh(i+1) - zh(i-1))
        Us(i) = InU/h(i)
      end do
      C(:) = Us(:) 
      
    ! Начало большого цикла по времени
    do j = 1, M

      t = t + dt
      print*, 't = ', t
      do i = 1, N
        U = C0*(100.*zh(i) - w*t)
        InU = U*0.5*(zh(i+1) - zh(i-1))
        Us(i) = InU/h(i)
      end do


     Flux(0) = 0. !w*Us(0)*C0
     Flux(1) = -C0*w*h(1)/(2.*h(1) + h(2)) !/1000. w*Us(1)*C0*h(1)/(2.*h(1)+h(2))

      do i = 2, N
        Cz(i) = M10(i)*C(i-2) + M11(i)*C(i-1) + M12(i)*C(i)
        Flux(i) = Cz(i)*w*C0
      end do

      do i = 1, N
        C(i) = C(i) + dt*(Flux(i) - Flux(i-1))/h(i)
       ! print*, dt*(Flux(i) - Flux(i-1))/h(i)
      end do

      do i = 1, N
	    !print*, i, Cz(i)
	    print*, i, Us(i), C(i)
        write(530,*) t,';',Us(i),';', C(i)
      end do

    end do

	print*, 'z: ', z
	print*, 'zh:', zh
	print*, 'h: ', h
    
    !print*, 'M10:', M10
	!print*, 'M11:', M11
	!print*, 'M12:', M12

end program nonlin
