import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.animation as animation
from matplotlib.animation import PillowWriter

# script for plotting result
if __name__ == '__main__':

    y_min = -1.
    y_max = 1.

    output_file = "res/Neuman_cos1.gif"
    res_path = 'res/diff_output.txt'

    f = pd.read_csv(res_path, header=None, delimiter='\s+').to_numpy()
    fig, ax = plt.subplots()
    ax.set_xlabel('z')
    x = f[1]
    z = np.arange(0, 1, 1 / len(x))
    plotLine, = ax.plot(z, x, 'r-')
    plotTitle = ax.set_title("t=0")
    ax.set_ylim(y_min, y_max)
    ax.set_xlim(0, max(z))


    def animate(t):
        pp = f[t]
        plotLine.set_ydata(pp)
        plotTitle.set_text('t = ' + str(round(t, 3)))
        return [plotLine, plotTitle]


    ani = animation.FuncAnimation(fig, func=animate, frames=np.arange(0, 120, 1), )
    # saving animation
    ani.save(output_file, writer=PillowWriter(fps=24))
