! test program for diffusion
program main
    use DIFFUSION_MOD, only: DIFFUSION

    implicit none

    integer, parameter :: N = 100        !< Number of levels of finite-difference grid
    integer, parameter :: t_steps = 200  !< Number of time steps
    real, parameter :: dt = 0.001        !< Timestep
    real, parameter :: tetha = 0.5       !< Weighting factor
    integer :: bctype(2)                 !< Kind of boundary conditions
    real :: bcs(2)                       !< Value of variable or flux at boundaries
    real, allocatable :: u(:)
    real, allocatable :: diff(:)         !< Diffusion coefficient
    real, allocatable :: work(:)
    real :: ddz(N + 2)                   !< Grid spacing
    integer :: i, j
    real :: out_u(t_steps, N + 1)

    allocate(diff(1:N), u(1:N+1))
    diff(:) = 1; u(:) = 0.

    bctype(1) = 2; bcs(1) = 0.
    bctype(2) = 2; bcs(2) = 0.

    do i = 1, N + 2
        ddz(i) = 1. / (N + 2)
    end do

    ! initial distribution
    allocate(work(1:N+1))
    do i = 1, N + 1
        work(i) = cos(4.*atan(1.) * (real(i) - 1) / N)
!        work(i) = (cos(3 * 4.*atan(1.) * ((real(i) - 1) / N + 1)) + 1) * 0.5
    end do

    do i = 1, t_steps
        out_u(i, :) = work(1:N+1)
        call DIFFUSION(N+1, bctype, bcs, dt, ddz, work, u, diff, tetha)
        work(1:N+1) = u(1:N+1)
    end do
    u(1:N+1) = work(1:N+1)
    deallocate(work)
    open(unit=12, FILE="res/diff_output.txt", ACTION="write", STATUS="replace")
    do i = 1, t_steps
        write(12,*) (out_u(i, j), j = 1, N + 1)
    end do
    close(12)

end program main