
module inmcm2constructor_mod

    !< @brief запись выхода модели inmcm для углеродного конструктора
    !< details
    ! вызов основной процедуры должен быть размещен в PBL после расчета PBLFLX и LAKE и до начала постобработки:
    !
    ! ...
    !#else
    !  print*, "ERROR in LAKE_mod : rules for LAKE_mod don't exist (see pbl.f90)"
    !  STOP 1
    !#endif
    !ENDIF
    !------------------------------------
    ! call inmcm2constructor_writing(i,j,ich)   ! <------
    !------------------------------------
    !UU10(I,J)=U10
    !VV10(I,J)=V10
    !TT2(I,J)=T2
    !QQ2(I,J)=Q2
    ! ...

    ! ПАМЯТКА
    ! ru-fyo - переключить IF_RU_FYO, fpsi_mod==2
    ! ural - fpsi_mod==1
    
    use netcdf
    use SOIL_CNST, only : ms

    implicit none
    
    private
    public :: inmcm2constructor_write
    
    character(*), parameter :: filename = 'inmcm_ru-fyo_1998-2015_0.5h.nc'
    
    real(8), parameter :: jday_ref = 693594.
    integer, parameter :: ms_fst = ms + 1
    integer, parameter :: ms_lst = ms + 13 ! по глубине корней
!     character(*), parameter :: nc_x_name = 'lon'
!     character(*), parameter :: nc_y_name = 'lat'
!     character(*), parameter :: nc_z_name = 'lev'
!     character(*), parameter :: nc_t_name = 'time'
!     character(*), parameter :: nc_nv_name = 'nv'
!     character(*), parameter :: nc_ns_name = 'ns'
!     character(*), parameter :: nc_us_name = 'UPBL'
!     character(*), parameter :: nc_vs_name = 'VPBL'
!     character(*), parameter :: nc_ta_name = 'TPBL'
!     character(*), parameter :: nc_qa_name = 'QPBL'
!     character(*), parameter :: nc_ps_name = 'PGR'
!     character(*), parameter :: nc_p_name = 'PRECIP'
!     character(*), parameter :: nc_rsw_name = 'TABL2_SDWSW'
!     character(*), parameter :: nc_rlw_name = 'TABL2_SDWLW'
!     character(*), parameter :: nc_tsrf1_name = 'TSRFOL1'
!     character(*), parameter :: nc_tgr_name = 'TGROLD'
!     character(*), parameter :: nc_s_name = 'SNOLD'
!     character(*), parameter :: nc_ga_name = 'CTxAUS'
!     character(*), parameter :: nc_tsoil_name = 'TO'
!     character(*), parameter :: nc_wsoil_name = 'WLO'
!     character(*), parameter :: nc_isoil_name = 'WIO'
!     character(*), parameter :: nc_mask_name = 'mask'
!     character(*), parameter :: nc_wssl_name = 'WSSL'
!     character(*), parameter :: nc_wssg_name = 'WSSG'
!     character(*), parameter :: nc_vegg_name = 'VEGG'
!     character(*), parameter :: nc_soilcol_name = 'SOILCOL'



    contains

        subroutine inmcm2constructor_write(ii, jj, ich)

            use PRMT, only : kl, nlonp2, nlat
            use SOIL_CNST, only : nv1, nv2, nsoil, ms, ml, nparv
            use SPECTR, only : twoband, mband
            use DRIVPAR, only : miss_v => missing_value
            use DOMAIN_MOD, only : i0, i1, j0, j1, tt=>kstep, lambda0, phi0
            use MEMORY, only : X_M
            use TABL2R, only: TABL2, SDWLW, SDWSW
            use VEG2, only : VEGG
            use PHYS, only : OLIM
            use RAB5, only : pi => ai
            use OUTPUT, only : O
            use SOILSOL, only : Z
            use DATE, only : date_prev
            use PARALLEL, only : INDEX
            use SERVICE, only : admAreaFrac
            
            integer, intent(in) :: ii, jj, ich
            integer :: i, j, k, n
            integer, save :: ncid, i_id, j_id, k_id, t_id, i_id_v, j_id_v, k_id_v, t_id_v, &
                           & nv_id, nv_id_v, ns_id, ns_id_v, &
                           & usid, vsid, Taid, qaid, psid, Pid, Rswid, Rlwid, &
                           & Tsrfid, Sid, sqid, Tsoilid, Wsoilid, Isoilid, &
                           & WSSLid, WSSGid, vegetid, colorid, Tgrid, maskid, lonid, latid, levid, raid
                            
            logical, save :: firstcall = .true.
            integer, save :: tt_mem = miss_v
            real :: work
            real(8) :: jday

            integer :: mask(nlonp2,nlat)
            
            real :: ROOTS(ML,NV2),WSSL(ML,NV2),WSSG(ML,NV2),FFF(NV2), &
                  & AMN(NV2),DVEG(NV2),RCO(NV2),VEG,TL,HINT,CLAKE,SVEG,SBARE 
            COMMON /VEINIT/ ROOTS,WSSL,WSSG,FFF,AMN,DVEG,RCO,VEG,TL,HINT,CLAKE,SVEG,SBARE 
            real :: albdir(mband),albdif(mband),cos_z,veget_ich(nv1),color_ich(9),albed
            common /albedo_block/ albdir,albdif,cos_z,veget_ich,color_ich,albed
            real :: TG(NSOIL,4),TSRFOL(4),TSRF(4)
            COMMON /TSRF/ TG,TSRFOL,TSRF
            real :: RF1,WICE,W10,DELTS,SSQ,SML,HSNW
            COMMON /PDIAG/ RF1,WICE,W10,DELTS,SSQ,SML,HSNW
            real :: ST,PGR,TGROLD,QGROLD,RADIAT,PRESIP,WSOLD,SNOLD,ZS,TSOILH,WSOILH, &
                  & HS,ES,TGRNEW,QGRNEW,WSNEW,SNNEW,RUNOF1,ROCU1,ROCT1,ACU1,ACT1,TAULAM,TAUFI,BOLD, &
                  & solad(twoband),solai(twoband)
            COMMON /BL/ ST,PGR,TGROLD,QGROLD,RADIAT,PRESIP,WSOLD,SNOLD,ZS,TSOILH,WSOILH, &
                      & HS,ES,TGRNEW,QGRNEW,WSNEW,SNNEW,RUNOF1,ROCU1,ROCT1,ACU1,ACT1,TAULAM,TAUFI,BOLD, &
                      & solad,solai
            real :: TSG(NSOIL,ML),WSG(NSOIL,ML),VSG(NSOIL,ML),WIG(NSOIL,ML),BG(NSOIL)
            COMMON /SOILG/ TSG,WSG,VSG,WIG,BG
            real :: VEGDAT(NPARV,NV2)
            COMMON /VEG1/ VEGDAT
            real :: SOILCOL(NSOIL,9)
            COMMON /SOILCOLOR/ SOILCOL
            real :: RADIUS,DLAM,DFI
            COMMON /RAB6/ RADIUS,DLAM,DFI
            
            if (firstcall) then

                call errhand( nf90_create('RES/'//filename, nf90_netcdf4, ncid) )
                call errhand( nf90_def_dim(ncid, 'lon', i1-i0+1, i_id) )
                call errhand( nf90_def_dim(ncid, 'lat', j1-j0+1, j_id) )
                call errhand( nf90_def_dim(ncid, 'lev', ms_lst-ms_fst+1, k_id) )
                call errhand( nf90_def_dim(ncid, 'time', nf90_unlimited, t_id) )
               ! call errhand( nf90_def_dim(ncid, 'nv', nv2, nv_id) )
               ! call errhand( nf90_def_dim(ncid, 'ns', 9, ns_id) )
                call errhand( nf90_def_var(ncid, 'lon', nf90_float, i_id, lonid) )
                call errhand( nf90_def_var(ncid, 'lat', nf90_float, j_id, latid) )
                call errhand( nf90_def_var(ncid, 'lev', nf90_float, k_id, levid) )
                call errhand( nf90_def_var(ncid, 'time', nf90_double, t_id, t_id_v) )
               ! call errhand( nf90_def_var(ncid, 'nv', nf90_int, nv_id, nv_id_v) )
               ! call errhand( nf90_def_var(ncid, 'ns', nf90_int, ns_id, ns_id_v) )
                call errhand( nf90_def_var(ncid, 'mask', nf90_int, (/i_id, j_id/), maskid) )
               ! call errhand( nf90_def_var(ncid, 'UPBL', nf90_float, (/i_id, j_id, t_id/), usid) )
               ! call errhand( nf90_put_att(ncid, usid, '_FillValue', miss_v) )
               ! call errhand( nf90_def_var(ncid, 'VPBL', nf90_float, (/i_id, j_id, t_id/), vsid) )
               ! call errhand( nf90_put_att(ncid, vsid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'TPBL', nf90_float, (/i_id, j_id, t_id/), Taid) )
                call errhand( nf90_put_att(ncid, Taid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'QPBL', nf90_float, (/i_id, j_id, t_id/), qaid) )
                call errhand( nf90_put_att(ncid, qaid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'PGR', nf90_float, (/i_id, j_id, t_id/), psid) )
                call errhand( nf90_put_att(ncid, psid, '_FillValue', miss_v) )
               ! call errhand( nf90_def_var(ncid, 'PRECIP', nf90_float, (/i_id, j_id, t_id/), Pid) )
               ! call errhand( nf90_put_att(ncid, Pid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'TABL2_SDWSW', nf90_float, (/i_id, j_id, t_id/), Rswid) )
                call errhand( nf90_put_att(ncid, Rswid, '_FillValue', miss_v) )
               ! call errhand( nf90_def_var(ncid, 'TABL2_SDWLW', nf90_float, (/i_id, j_id, t_id/), Rlwid) )
               ! call errhand( nf90_put_att(ncid, Rlwid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'TSRFOL1', nf90_float, (/i_id, j_id, t_id/), Tsrfid) )
                call errhand( nf90_put_att(ncid, Tsrfid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'TGROLD', nf90_float, (/i_id, j_id, t_id/), Tgrid) )
                call errhand( nf90_put_att(ncid, Tgrid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'SNOLD', nf90_float, (/i_id, j_id, t_id/), Sid) )
                call errhand( nf90_put_att(ncid, Sid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'CTxAUS', nf90_float, (/i_id, j_id, t_id/), raid) )
                call errhand( nf90_put_att(ncid, raid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'TO', nf90_float, (/i_id, j_id, k_id, t_id/), Tsoilid) )
                call errhand( nf90_put_att(ncid, Tsoilid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'WLO', nf90_float, (/i_id, j_id, k_id, t_id/), Wsoilid) )
                call errhand( nf90_put_att(ncid, Wsoilid, '_FillValue', miss_v) )
                call errhand( nf90_def_var(ncid, 'WIO', nf90_float, (/i_id, j_id, k_id, t_id/), Isoilid) )
                call errhand( nf90_put_att(ncid, Isoilid, '_FillValue', miss_v) )
               ! call errhand( nf90_def_var(ncid, 'WSSL', nf90_float, (/i_id, j_id, k_id, nv_id/), WSSLid) )
               ! call errhand( nf90_put_att(ncid, WSSLid, '_FillValue', miss_v) )
               ! call errhand( nf90_def_var(ncid, 'WSSG', nf90_float, (/i_id, j_id, k_id, nv_id/), WSSGid) )
               ! call errhand( nf90_put_att(ncid, WSSGid, '_FillValue', miss_v) )
               ! call errhand( nf90_def_var(ncid, 'VEGG', nf90_float, (/i_id, j_id, nv_id/), vegetid) )
               ! call errhand( nf90_put_att(ncid, vegetid, '_FillValue', miss_v) )
               ! call errhand( nf90_def_var(ncid, 'SOILCOL', nf90_float, (/i_id, j_id, ns_id/), colorid) )
               ! call errhand( nf90_put_att(ncid, colorid, '_FillValue', miss_v) )
                call errhand( nf90_enddef(ncid) )
                
                do i = i0, i1
                    work = 0.01*nint(100.*(lambda0+(i-1)*dlam)*180./pi)
                    call errhand( nf90_put_var(ncid, lonid, (/work/), (/i-i0+1/), (/1/)) )
                enddo
                do j = j0, j1
                    work = 0.01*nint(100.*(phi0+(j-1)*dfi)*180./pi)
                    call errhand( nf90_put_var(ncid, latid, (/work/), (/j-j0+1/), (/1/)) )
                enddo
                do k = ms_fst, ms_lst
                    work = 0.01*z(k)
                    call errhand( nf90_put_var(ncid, levid, (/work/), (/k-ms_fst+1/), (/1/)) )
                enddo
               ! do n = 1, nv2
               !     call errhand( nf90_put_var(ncid, nv_id_v, (/n/), (/n/), (/1/)) )
               ! enddo
               ! do n = 1, 9
               !     call errhand( nf90_put_var(ncid, ns_id_v, (/n/), (/n/), (/1/)) )
               ! enddo
                
                mask(:,:) = 0
                do i = i0, i1
                    do j = j0, j1
                        if (olim(i,j) == 1 .and. sum(admAreaFrac(i,j,:)) > 0. .and. index(i,j) /= 36673) then
                            mask(i,j) = 1
                        else
                            mask(i,j) = 0
                        endif
                    enddo
                enddo
                call errhand( nf90_put_var(ncid, maskid, mask(i0:i1,j0:j1), (/1,1/), (/i1-i0+1,j1-j0+1/)) )
                
            endif
            
            if (tt /= tt_mem) then
                call date2jday(date_prev, jday)
                call errhand( nf90_put_var(ncid, t_id_v, (/jday/), (/tt/), (/1/)) )
                tt_mem = tt
            endif
            
           ! if (tt == 1) then
           !     call errhand( nf90_put_var(ncid, WSSLid, WSSL(ms_fst:ms_lst,:), &
           !                   & (/ii-i0+1,jj-j0+1,1,1/), (/1,1,ms_lst-ms_fst+1,nv2/)) )
           !     call errhand( nf90_put_var(ncid, WSSGid, WSSG(ms_fst:ms_lst,:), &
           !                   & (/ii-i0+1,jj-j0+1,1,1/), (/1,1,ms_lst-ms_fst+1,nv2/)) )
           !     call errhand( nf90_put_var(ncid, vegetid, vegg(ich,:), (/ii-i0+1,jj-j0+1,1/), (/1,1,nv2/)) )
           !     call errhand( nf90_put_var(ncid, colorid, soilcol(ich,:), (/ii-i0+1,jj-j0+1,1/), (/1,1,9/)) )
           ! endif
            
           ! call errhand( nf90_put_var(ncid, usid, (/X_M(ii,KL,1,jj,2)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
           ! call errhand( nf90_put_var(ncid, vsid, (/X_M(ii,KL,2,jj,2)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, Taid, (/X_M(ii,KL,3,jj,2)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, qaid, (/X_M(ii,KL,4,jj,2)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, psid, (/X_M(ii,KL,5,jj,2)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
           ! call errhand( nf90_put_var(ncid, Pid, (/PRESIP/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, Rswid, (/TABL2(ii,jj,SDWSW)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
           ! call errhand( nf90_put_var(ncid, Rlwid, (/TABL2(ii,jj,SDWLW)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, Tsrfid, (/TSRFOL(1)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, Tgrid, (/TGROLD/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, Sid, (/SNOLD/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, raid, (/1./O%ra(ii,jj)/), (/ii-i0+1,jj-j0+1,tt/), (/1,1,1/)) )
            call errhand( nf90_put_var(ncid, Tsoilid, TSG(ich,ms_fst:ms_lst), (/ii-i0+1,jj-j0+1,1,tt/), (/1,1,ms_lst-ms_fst+1,1/)) )
            call errhand( nf90_put_var(ncid, Wsoilid, WSG(ich,ms_fst:ms_lst), (/ii-i0+1,jj-j0+1,1,tt/), (/1,1,ms_lst-ms_fst+1,1/)) )
            call errhand( nf90_put_var(ncid, Isoilid, WIG(ich,ms_fst:ms_lst), (/ii-i0+1,jj-j0+1,1,tt/), (/1,1,ms_lst-ms_fst+1,1/)) )
            
            if (firstcall) firstcall = .false.

        end subroutine



        subroutine errhand(ios)
            integer, intent(in) :: ios
            real :: a = 1.
            if (ios /= nf90_noerr) then
                print*, trim(nf90_strerror(ios))
                print*, 1./(a-a)  ! crash
            endif
        end subroutine



        subroutine date2jday(date_c, jday)
            
            use DATE, only : datetype
            
            type(datetype), intent(in) :: date_c
            real(8), intent(out) :: jday
            
            integer :: y, m, d, h, mn, sc
            integer :: n400y, n100y, n4y, n1y, work, doy, days(12)
            real(8) :: jday_abs
            
            y = date_c%y
            m = date_c%m
            d = date_c%d
            h = date_c%h
            mn = date_c%mn
            sc = 0.
            
            work = date_c%y - 1
            n400y = work / 400
            work = mod(work,400)
            n100y = work / 100
            work = mod(work,100)
            n4y = work / 4
            work = mod(work,4)
            n1y = work
            
            if (m == 1) then
                doy = d
            else
                days = days_in_year(y)
                doy = sum(days(1:m-1)) + d
            endif
            
            jday_abs = n400y*(303*365+97*366) + n100y*(76*365+24*366) + n4y*(3*365+1*366) + n1y*365 + doy
            jday_abs = jday_abs + (h + mn/60. + sc/3600.)/24.
            jday = jday_abs - jday_ref
            
            contains
            
                function days_in_year(year)
                    integer, intent(in) :: year
                    logical :: is_leap
                    integer, parameter :: days_norm(12) = (/31,28,31,30,31,30,31,31,30,31,30,31/)
                    integer, parameter :: days_leap(12) = (/31,29,31,30,31,30,31,31,30,31,30,31/)
                    integer :: days_in_year(12)
                    is_leap = (mod(year,4) == 0. .and. (mod(year,100) /= 0 .or. mod(year,400) == 0))
                    if (is_leap) then
                        days_in_year = days_leap
                    else
                        days_in_year = days_norm
                    end if
                end function days_in_year
            
        end subroutine
        
end module
