#!/bin/bash

set -e            # exit if error
set -o pipefail   # bash only: error can be in any place in pipeline

gfortran_keys_compile="-O3 -ffree-line-length-none"
gfortran_keys_linking=""

netcdf_path="/usr/local/"
netcdf_keys_compile="-I${netcdf_path}include -L${netcdf_path}lib"
netcdf_keys_linking="-lnetcdff"

gprof_keys_compile=""
gprof_keys_linking=""

for arg in "$@"
do
    if [ "$arg" == "-h" ] || [ "$arg" == "--help" ]; then
        echo "help"
        echo "possible arguments: -h (--help) --debug -pg"
        exit 0
    fi
    if [ "$arg" == "--debug" ]; then
        gfortran_keys_compile="-g -ffpe-trap=invalid,zero,overflow -fcheck=all -fbacktrace -ffree-line-length-none"
        gfortran_keys_linking=""
    fi
    if [ "$arg" == "-pg" ]; then
        gprof_keys_compile="-pg"
        gprof_keys_linking="-pg"
    fi
done

keys_compile="$gfortran_keys_compile $netcdf_keys_compile $gprof_keys_compile"
keys_linking="$gfortran_keys_linking $netcdf_keys_linking $gprof_keys_linking"

rm -f bin/*.o
rm -f bin/*.mod
rm -f bin/*.smod
rm -f bin/*.out
rm -f gmon.out
rm -f run.exe

gfortran $keys_compile -c source/const.f90 -o bin/const.o -Jbin
gfortran $keys_compile -c source/paths.f90 -o bin/paths.o -Jbin
gfortran $keys_compile -c source/config.f90 -o bin/config.o -Jbin
gfortran $keys_compile -c source/netcdf_kit.f90 -o bin/netcdf_kit.o -Jbin
gfortran $keys_compile -c source/datetime.f90 -o bin/datetime.o -Jbin
gfortran $keys_compile -c source/grid.f90 -o bin/grid.o -Jbin
gfortran $keys_compile -c source/environment/environment_core.f90 -o bin/environment_core.o -Jbin
gfortran $keys_compile -c source/environment/environment_data_generator.f90 -o bin/environment_data_generator.o -Jbin
gfortran $keys_compile -c source/environment/environment_data_station.f90 -o bin/environment_data_station.o -Jbin
gfortran $keys_compile -c source/environment/environment_data_lsm_offline.f90 -o bin/environment_data_lsm_offline.o -Jbin
gfortran $keys_compile -c source/environment/environment_model_INMCM.f90 -o bin/environment_model_INMCM.o -Jbin
gfortran $keys_compile -c source/environment/environment.f90 -o bin/environment.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_core.f90 -o bin/carbon_core.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_model_to_core_arg_kit.f90 -o bin/carbon_model_to_core_arg_kit.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_model_to_core_par_kit.f90 -o bin/carbon_model_to_core_par_kit.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_model_to_core_fun_kit.f90 -o bin/carbon_model_to_core_fun_kit.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_model_to_core.f90 -o bin/carbon_model_to_core.o -Jbin
gfortran $keys_compile -c ui3_carbon_model_aux.f90 -o bin/carbon_model_user_aux.o -Jbin
gfortran $keys_compile -c ui2_carbon_model.f90 -o bin/carbon_model_user.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_models/carbon_model_INMCM_aux.f90 -o bin/carbon_model_INMCM_aux.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_models/carbon_model_INMCM.f90 -o bin/carbon_model_INMCM.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_models/carbon_model_SOCS_aux.f90 -o bin/carbon_model_SOCS_aux.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_models/carbon_model_SOCS.f90 -o bin/carbon_model_SOCS.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_models/carbon_model_ROTHC_aux.f90 -o bin/carbon_model_ROTHC_aux.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_models/carbon_model_ROTHC.f90 -o bin/carbon_model_ROTHC.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_solver.f90 -o bin/carbon_solver.o -Jbin
gfortran $keys_compile -c source/carbon/carbon_postprocessing.f90 -o bin/carbon_postprocessing.o -Jbin
gfortran $keys_compile -c source/carbon/carbon.f90 -o bin/carbon.o -Jbin
gfortran $keys_compile -c source/main.f90 -o bin/main.o -Jbin

gfortran -o run.exe bin/*.o $keys_linking 

if [ ! -e data/inmcm_ru-fyo_fluxnet_1998-2015_0.5h.nc ]; then
    tar -xzf data/inmcm_ru-fyo_fluxnet_1998-2015_0.5h.tar.gz -C data/
fi

if [ ! -e data/inmcm_05x05 ]; then
    tar -xzf data/inmcm_05x05.tar.gz -C data/
fi

doxygen ./docs/doxyfile &> /dev/null

exit 0
