
!" КОНСТРУКТОР МОДЕЛЕЙ УГЛЕРОДНОГО ЦИКЛА / окно настроек 3 из 3
!"
!"   Модель углеродного цикла : дополнительные расчеты
!" 
!"   (используется только при выборе опции carbon_model_type = 'other' в окне настроек 1)
!"   (технически представляет собой fortran-модуль, по структуре аналогичный модулям source/carbon/carbon_model_*_aux.f90)
!"   
!"   Комментарий:
!"     - если необходимо выполнить дополнительные расчеты, разместите их в этом модуле внутри предлагаемых процедур
!"     - процедуры вызываются последовательно на разных этапах основного цикла программы (см. source/main.f90)
!"     - для выполнения расчётов требуется предворительное создание файла формата .txt, с заданием там месячных значений:
!"      Поступление углерода, температура, распределение растительности
!"
!"   Реализована модель Rothc



module carbon_model_user_aux

    use const, only : yrs, day2sec, pi

implicit none
 ! пулы
    real, dimension(:,:,:), pointer :: Catm               !< атмосфера
    real, dimension(:,:,:), pointer :: Cveg               !< растительность
    real, dimension(:,:,:), pointer :: CDPM               !< разлагаемый растительный материал / decomposable plant material 
    real, dimension(:,:,:), pointer :: CRPM               !< устойчивый растительный материал / resistant plant material
    real, dimension(:,:,:), pointer :: CBIO               !< пул микробной биомассы / microbial biomass pool
    real, dimension(:,:,:), pointer :: CHUM               !< долгоживущий гумусовый пул / long lived humified pool
    ! потоки n_Catm, n_Cveg, n_CDPM, n_CRPM, n_CBIO, n_CHUM
    real, dimension(:,:,:), pointer :: litterfall1        !< Между растениями и почвой DPM
    real, dimension(:,:,:), pointer :: litterfall2        !< Между растением и почвой RPM
    real, dimension(:,:,:), pointer :: atmosphere1        !< Между атмосферой и почвой BIO
    real, dimension(:,:,:), pointer :: atmosphere2        !< Между атмосферой и почвой HUM
    real, dimension(:,:,:), pointer :: respiration1       !< Между почвой DPM и атмосферой    ! 1 - DPM
    real, dimension(:,:,:), pointer :: respiration2       !< Между почвой RPM и атмосферой    ! 2 - RPM
    real, dimension(:,:,:), pointer :: respiration3       !< Между почвой BIO и атмосферой    ! 3 - BIO
    real, dimension(:,:,:), pointer :: respiration4       !< Между почвой HUM и атмосферой    ! 4 - HUM
! ------- Serve value -------
    integer, parameter :: ntiles = 1                      !< ?
    integer, parameter :: ntiles2 = 4                     !< В данном случае, номер пула
    !integer, parameter :: ntiles3 = 6
    integer :: k = 1                                      !< Номер месяца с начала работы программы
    integer :: ik = 1                                     !< Номер месяца с начала работы программы
    real :: work                                          !< Переменная для вывода значений опада (lambdac)
! ------- Type of climate ------
    integer, parameter :: mnc = 744           ! mnc = (год финиша - год старта + 1)*12
    ! (43+1)*12 = 528 ! Для случая Ростов: Rostov_Temp Rostov_Veg 1974 - 2017
    ! (72+1)*12 = 876 ! Для случая ДАОС3:    DAO3_Temp   DAO3_Veg 1939 - 2011
    ! (74+1)*12 = 900 ! Для случая ДАОС4:    DAO4_Temp   DAO4_Veg 1937 - 2011
	! (61+1)*12 = 744 ! Для случая ТРЖК:     TRGK_Temp   TRGK_Veg 1956 - 2017
	! (49+1)*12 = 600 ! Для случая ВЛДМР:   VLDMR_Temp  VLDMR_Veg 1968 - 2017
! ------- Initial value ------
    real :: Rs = 0.0                          !< Функции дыхания
    real :: RDPM = 0.0                        !< Дыхание пула DPM
    real :: RRPM = 0.0                        !< Дыхание пула RPM
    real :: RBIO = 0.0                        !< Дыхание пула BIO
    real :: RHUM = 0.0                        !< Дыхание пула HUM
! ------- Functions ------------
    real :: a1,a2,a3,a4                       !< Функции коэффициентов для пулов
    real :: Ft, Fs, Fv, Fa                    !< Функции температуры, влажности, фракции растительного покрова, общая функция, [dim]
    real :: fdpm                              !< Функция определяющая разлагаемую часть опада, [dim]
! ------- Coefficients ------------
    real, parameter :: ks(ntiles2) = (/ 3.22*(1.E-7), 9.65*(1.E-9), 2.12*(1.E-8), 6.43*(1.E-10)/)
    !< Скорость дыхания единицы массы каждого пула в стандартных условиях, [1-s]
    real, parameter :: alphadr = 1.44         !< Определяет соотношение поступления опада между DPM и RPM, [dim],
	! Для деревьев, для кустарников, для натуральной травы, для СХ (/ 0.25, 0.33, 0.67, 1.44 /)
    real :: bettar                            !< Fraction of soil respiration, [%] from 0 to 1
! ------ Climate variables --------
    real :: MOI(mnc)                          !< Средняя влажность почвы в месяц, [dim]
	real :: s0                                !< Оптимальная влажность почвы, [dim]
    real :: s                                 !< Влажность почвы, [dim]
	real :: smin                              !< Переменные для функций, [dim]
    real :: sw                                !< Влажность увядания DAO: 0.120 Rostov: 0.146

    real :: Temp(mnc)                         !< Средняя температура в месяц, [Celsius]
    real :: Tsoil                             !< Температура почвы в день, [K]
    real :: veg                               !< Концентрация растения в день, [%] 
    real :: vegy(mnc)                         !< Средняя концентрация растений в месяц, [%]
! ------ Litterfall --------
    real :: lambdac = 0.1428/yrs*12           !< Поступление углерода в почву, [kg/m**3 / year]
! ------ Initialization ------
    real :: cs
	
contains

    subroutine carbon_model_init()
	
      s0 = 0.5*(1 + sw)
      smin = 1.7*sw
	  
      fdpm = alphadr/(1 + alphadr)

    select case (mnc)

      case(528)

        sw = 0.146
        bettar = 0.41
		
        open (unit = 1, file = "Rostov_Temp.txt")
        read(1,*) Temp
        close (1)

        open (unit = 1, file = "Rostov_Veg.txt")
        read(1,*) vegy
        close (1)
	  
        open (unit = 1, file = "Rostov_MOI.txt")
        read(1,*) MOI
        close (1)

      case(876)
	  
        sw = 0.120
        bettar = 0.25
		
        open (unit = 1, file = "DAO3_Temp.txt")
        read(1,*) Temp
        close (1)

        open (unit = 1, file = "DAO3_Veg.txt")
        read(1,*) vegy
        close (1)

        open (unit = 1, file = "DAO3_MOI.txt")
        read(1,*) MOI
        close (1)

	  case(900)

	    sw = 0.120
        bettar = 0.25

        open (unit = 1, file = "DAO4_Temp.txt")
        read(1,*) Temp
        close (1)

        open (unit = 1, file = "DAO4_Veg.txt")
        read(1,*) vegy
        close (1)

        open (unit = 1, file = "DAO4_MOI.txt")
        read(1,*) MOI
        close (1)
		
	  case(600)

	    sw = 0.120
        bettar = 0.08

        open (unit = 1, file = "VLDMR_Temp.txt")
        read(1,*) Temp
        close (1)

        open (unit = 1, file = "VLDMR_Veg.txt")
        read(1,*) vegy
        close (1)

        MOI = 0.3

	  case(744)

	    sw = 0.120
        bettar = 0.07

        open (unit = 1, file = "TRGK_Temp.txt")
        read(1,*) Temp
        close (1)

        open (unit = 1, file = "TRGK_Veg.txt")
        read(1,*) vegy
        close (1)

        MOI = 0.3

	  case default
        print*, 'Wrong number, try again(m2)'
	  end select

    end subroutine



    subroutine carbon_model_calc_at_timestep() !Пусто


    end subroutine



    subroutine carbon_model_calc_at_cell(ii,jj)

        use grid, only: date_c

        integer, intent(in) :: ii, jj

		Tsoil = Temp(ik)
        s = MOI(ik)
        veg = vegy(ik)
        work = lambdac

        if (ik == mnc) ik = 0
        ik = ik+1
        k = k+1

        if (s >= s0) then 
          Fs = 1 - 0.8*(s-s0)
        else if (smin < s .and. s < s0) then
          Fs = 0.2 + 0.8*(s-smin)/(s0-smin)
        else if (s <= smin) then
          Fs = 0.2
        end if

        if (Tsoil >= -18.27) then
          Ft = 47.91/(1 + exp(106.06/(Tsoil + 18.27)))
		else 
		  Ft = 0
		end if
		
        Fv = 0.6 + 0.4*(1 - veg)

        Fa = Ft*Fv*Fs

        a1 = ks(1)*Fa
        a2 = ks(2)*Fa
        a3 = ks(3)*Fa
        a4 = ks(4)*Fa

        RDPM = a1*CDPM(ii,jj,1)
        RRPM = a2*CRPM(ii,jj,1)
        RBIO = a3*CBIO(ii,jj,1)
        RHUM = a4*CHUM(ii,jj,1)

        Rs = RDPM + RRPM + RBIO + RHUM

        ! ---- Initialization ------
        Cs = CDPM(ii,jj,1) + CRPM(ii,jj,1) + CBIO(ii,jj,1) + CHUM(ii,jj,1)

        print*, 'important thing 1, ', cs
        !print*, 'important thing 2, ', s
        !print*, 'important thing 3, ', veg
        !print*, 'important thing 4, ', ik

    end subroutine



    subroutine carbon_model_calc_at_tile(ii,jj,nn) !Пусто

        integer, intent(in) :: ii, jj, nn



    end subroutine



    subroutine carbon_model_postprocessing() !Вывод переменных

        use grid, only : date_c

        print*, 'finish thing 1, ', CDPM(:,:,1)/cs*100,'%'
        print*, 'finish thing 2, ', CRPM(:,:,1)/cs*100,'%'
        print*, 'finish thing 3, ', CBIO(:,:,1)/cs*100,'%'
        print*, 'finish thing 4, ', CHUM(:,:,1)/cs*100,'%'

        write(500,*) date_c%timestamp,';',CDPM(:,:,1),';',CRPM(:,:,1),';',CBIO(:,:,1),';',CHUM(:,:,1)

    end subroutine


end module
