#get from loaded modules versions of compilers


#NETCDF support
if (USE_NETCDF)
    set(CUSTOM_NETCDF false FORCE)
    find_package(Net_CDFCxx)
endif()


if ( COMPILER STREQUAL "intel")
    if (NO_MPI)
        set(CMAKE_C_COMPILER       icc      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
        set(CMAKE_CXX_COMPILER     c++      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
        set(CMAKE_Fortran_COMPILER ifort    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
    else()
        set(CMAKE_C_COMPILER       mpiicc  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
        set(CMAKE_CXX_COMPILER     mpiicpc CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
        set(CMAKE_Fortran_COMPILER mpiifort CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
    endif()
    set(comp_flags -O3-restrict -alias-const -parallel -funroll-loops -no-ansi-alias -mavx -fma CACHE STRING FORCE)
endif()

if ( COMPILER STREQUAL "intel_oneapi")
    messege(ERROR "ONEAPI is not supported on IFA cluster")
endif()

if ( COMPILER STREQUAL "gnu")
    if (NO_MPI)
        set(CMAKE_C_COMPILER       gcc      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
        set(CMAKE_CXX_COMPILER     g++      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
        set(CMAKE_Fortran_COMPILER gfortran    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
    else()
        set(CMAKE_C_COMPILER       mpicc  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
        set(CMAKE_CXX_COMPILER     mpicxx CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
        set(CMAKE_Fortran_COMPILER mpifort CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
    endif()
    set(comp_flags -O3 -fno-strict-aliasing -funroll-loops -march=native  -mavx -std=c++0x CACHE  STRING  "comp_flags to add" FORCE)
endif()

#specify stuff for run-script
set(cluster_queue "epyc" CACHE STRING "queue" FORCE)

if ( COMPILER  STREQUAL "intel" OR COMPILER  STREQUAL "intel_oneapi")
    set(run_exec "srun -u" CACHE STRING "exec run" FORCE)
    set(prerun_env_export "module load mpi/impi && export I_MPI_PMI_LIBRARY=/usr/lib64/libpmi.so" CACHE STRING "prerun exports" FORCE)
endif()


if ( COMPILER  STREQUAL "gnu")
    set(run_exec "mpirun" CACHE STRING "exec run" FORCE)
    set(prerun_env_export "module load mpi/OpenMPI" CACHE STRING "prerun exports" FORCE)
endif ()
message("prerun exprots:" ${prerun_env_export})
message("run executable is:" ${run_exec})
message("compiler choice:" ${COMPILER})
