#stuff for ubuntu 22.04 or smthing


#NETCDF support
if (USE_NETCDF)
    set(CUSTOM_NETCDF false FORCE)
    find_package(Net_CDFCxx)
endif()


if ( COMPILER STREQUAL "intel")
    if (NO_MPI)
        set(CMAKE_C_COMPILER       icc      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
        set(CMAKE_CXX_COMPILER     c++      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
        set(CMAKE_Fortran_COMPILER ifort    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
    else()
        set(CMAKE_C_COMPILER       mpiicc  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
        set(CMAKE_CXX_COMPILER     mpiicpc CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
        set(CMAKE_Fortran_COMPILER mpiifort CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
    endif()
    set(comp_flags -O3 -restrict -alias-const -parallel -funroll-loops -no-ansi-alias -xhost CACHE STRING FORCE)
endif()

if ( COMPILER STREQUAL "intel_oneapi")
        if (NO_MPI)
        set(CMAKE_C_COMPILER       icx      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
        set(CMAKE_CXX_COMPILER     icpx      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
        set(CMAKE_Fortran_COMPILER ifort    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
    else()
        set(CMAKE_C_COMPILER       mpiicc -cc=icx  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
        set(CMAKE_CXX_COMPILER     mpiicpc -cxx=icpx CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
        set(CMAKE_Fortran_COMPILER mpiifort -fc=ifx CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
    endif()
    set(comp_flags -O3 -no-ansi-alias -funroll-loops -xhost   -Wno-tautological-constant-compare CACHE STRING "comp_flags to add" FORCE)
endif()

if ( COMPILER STREQUAL "gnu")
    if (NO_MPI)
        set(CMAKE_C_COMPILER       gcc      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
        set(CMAKE_CXX_COMPILER     g++      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
        set(CMAKE_Fortran_COMPILER gfortran    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
    else()
        set(CMAKE_C_COMPILER       gcc  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
        set(CMAKE_CXX_COMPILER     g++ CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
        set(CMAKE_Fortran_COMPILER gfortran CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
    endif()
    set(comp_flags -O3 -fno-strict-aliasing -funroll-loops -march=native -std=c++0x CACHE  STRING  "comp_flags to add" FORCE)
endif()

#specify stuff for run-script
set(cluster_queue "none" CACHE STRING "queue" FORCE)

if ( COMPILER  STREQUAL "intel" OR COMPILER  STREQUAL "intel_oneapi")
    set(run_exec "mpiexec" CACHE STRING "exec run" FORCE)
    set(prerun_env_export " " CACHE STRING "prerun exports" FORCE)
endif()


if ( COMPILER  STREQUAL "gnu")
    set(run_exec "mpirun" CACHE STRING "exec run" FORCE)
    set(prerun_env_export " " CACHE STRING "prerun exports" FORCE)
endif ()
message("prerun exprots:" ${prerun_env_export})
message("run executable is:" ${run_exec})
message("compiler choice:" ${COMPILER})
