#config for macosx with manually specified compiler for development

if (USE_NETCDF)
set(CUSTOM_NETCDF false)
endif()

# adding compiler options for Intel
if ( compiler_lc STREQUAL "intel")
    if (NO_MPI)
        set(CMAKE_C_COMPILER       icc      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
        set(CMAKE_CXX_COMPILER     c++      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
        set(CMAKE_Fortran_COMPILER ifort    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
    else()
        set(CMAKE_C_COMPILER       mpiicpc  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
        set(CMAKE_CXX_COMPILER     mpiicpc CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
        set(CMAKE_Fortran_COMPILER mpiifort CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
    endif()
    set(comp_flags " -O3 -restrict -alias-const -parallel -funroll-loops -no-ansi-alias -march=core-avx2 -xcore-avx2 ")
endif()

if ( compiler_lc STREQUAL "intel_oneapi")
    if (NO_MPI)
        set(CMAKE_C_COMPILER       icx      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
        set(CMAKE_CXX_COMPILER     icpx      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
        set(CMAKE_Fortran_COMPILER ifort    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
    else()
        set(CMAKE_C_COMPILER       mpiicc -cc=icx  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
        set(CMAKE_CXX_COMPILER     mpiicpc -cc=icpx CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
        set(CMAKE_Fortran_COMPILER mpiifort -fc=ifx CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
    endif()
    set(comp_flags " -O3 -no-ansi-alias -funroll-loops -Wno-tautological-constant-compare ")
endif()

if ( compiler_lc STREQUAL "gnu")
    if (NO_MPI)
        set(CMAKE_C_COMPILER       gcc      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
        set(CMAKE_CXX_COMPILER     g++      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
        set(CMAKE_Fortran_COMPILER gfortran    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
    else()
        set(CMAKE_C_COMPILER       mpicc  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
        set(CMAKE_CXX_COMPILER     mpicxx CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
        set(CMAKE_Fortran_COMPILER mpifort CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
    endif()
    set(comp_flags " -O3 -fno-strict-aliasing -funroll-loops -mavx2  -no-pie")
endif()

#specify stuff for run-script
set(cluster_queue "normal")