#get from loaded modules versions of compilers


#NETCDF support
if (USE_NETCDF)
set(CUSTOM_NETCDF true)
if ( ${compiler_lc} STREQUAL "intel" OR ${compiler_lc} STREQUAL "intel_oneapi")
  set(NETCDF_PATH "/opt/ohpc/pub/libs/intel/impi/netcdf/4.9.0/")
  set(NETCDF_INC  "${NETCDF_PATH}include")
  set(NETCDF_LIB  "${NETCDF_PATH}lib")
  set(HDF5_LIB  "/opt/ohpc/pub/libs/intel/impi/hdf5/1.10.8/lib")
  set(NetCDF_LINK_FLAGS "-L${NETCDF_LIB} -lnetcdf -L${HDF5_LIB} -lhdf5")
else ()
   messege(ERROR "NetCDF is not supported with GNU on INM cluster")
endif()
endif()


if ( compiler_lc STREQUAL "intel")
if (NO_MPI) 
  set(CMAKE_C_COMPILER       icc      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
  set(CMAKE_CXX_COMPILER     c++      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
  set(CMAKE_Fortran_COMPILER ifort    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
else()
  set(CMAKE_C_COMPILER       mpiicpc  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
  set(CMAKE_CXX_COMPILER     mpiicpc CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
  set(CMAKE_Fortran_COMPILER mpiifort CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
endif()
  set(comp_flags " -O3 -restrict -alias-const -parallel -funroll-loops -no-ansi-alias -march=core-avx2 -xcore-avx2 ")
endif()

if ( compiler_lc STREQUAL "intel_oneapi")
if (NO_MPI) 
  set(CMAKE_C_COMPILER       icx      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
  set(CMAKE_CXX_COMPILER     icpx      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
  set(CMAKE_Fortran_COMPILER ifort    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
else()
  set(CMAKE_C_COMPILER       mpiicc -cc=icx  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
  set(CMAKE_CXX_COMPILER     mpiicpc -cc=icpx CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
  set(CMAKE_Fortran_COMPILER mpiifort -fc=ifx CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
endif()
  set(comp_flags " -O3 -no-ansi-alias -funroll-loops -xcore-avx2    -Wno-tautological-constant-compare ")
endif()

if ( compiler_lc STREQUAL "gnu")
if (NO_MPI) 
  set(CMAKE_C_COMPILER       gcc      CACHE STRING "C compiler"       FORCE) # C compiler for serial build
  set(CMAKE_CXX_COMPILER     g++      CACHE STRING "CXX compiler"     FORCE) # C++ compiler for serial build
  set(CMAKE_Fortran_COMPILER gfortran    CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for serial build
else()
  set(CMAKE_C_COMPILER       mpicc  CACHE STRING "C compiler"       FORCE) # C compiler for parallel build
  set(CMAKE_CXX_COMPILER     mpicxx CACHE STRING "CXX compiler"     FORCE) # C++ compiler for parallel build
  set(CMAKE_Fortran_COMPILER mpifort CACHE STRING "Fortran compiler" FORCE) # Fortran compiler for parallel build
endif()
set(comp_flags " -O3 -fno-strict-aliasing -funroll-loops -mavx2  -std=c++0x ")
endif()

#specify stuff for run-script
set(cluster_queue "normal")