#!/usr/bin/python

from flake_surf_scheme import sfcflx
from flux1 import fluxes_repina
import os
import numpy as np
from matplotlib import pyplot as plt

path = os.path.expanduser('/media/victor/main/Files/main/observdata/vilui15/')

file1 = open(path+'lake_T_wind_H.csv','r')
file2 = open(path+'all.dat','r')

zref = 2.
fetch = 1.e+3
wr = 2.
tempair = 15.
humair = 1.e-4
tsurf = 16.
pressure = 1.e+5
l1 = 0.

#Reading file with meteo data
metdata = file1.readlines()
delim1 = ','
#No. of columns
ntemp = 2
nwind = 3
nhflux = 4

ndata = len(metdata)
press = np.zeros(ndata)
watertemp = np.zeros(ndata)
airtemp = np.zeros(ndata)
airhum = np.zeros(ndata)
relhum = np.zeros(ndata)
speed = np.zeros(ndata)
hflux = np.zeros(ndata)
hflux2 = np.zeros(ndata)
elatent2 = np.zeros(ndata)

#Reading file with water temperature
hydrodata = file2.readlines()
delim2 = ','
nwattemp = 5

k = 0
for i in range(ndata):
        meteo = metdata[i].split(delim1)
        watertemp[i] = 0.
        for j in range(10):
                #print(hydrodata[k])
                watertemp[i] = watertemp[i] + float(hydrodata[k].split(delim2)[nwattemp-1])
                k += 1
        watertemp[i] = watertemp[i]/10.        
	speed[i] = float(meteo[nwind-1])
	airtemp[i] = float(meteo[ntemp-1])
	airhum[i] = humair
	press[i] = pressure
	relhum[i] = 1.
        tau,hflux[i],elatent,xx = sfcflx.sfcflx_momsenlat(zref, zref, fetch, \
        speed[i], airtemp[i] + 273.15, airhum[i], watertemp[i] + 273.15, press[i], l1)
        #print(watertemp)

hflux2,elatent2 = fluxes_repina(airtemp,watertemp,speed,relhum,press/100.,zref,zref,ndata,ndata)

plt.plot(hflux)
plt.plot(hflux2)
plt.show()
