# -*- coding: utf-8 -*- 

from plot_timser import plot_timeser
import matplotlib.pyplot as plt # for plotting
import numpy as nm
import phys
from matplotlib import rc

# Enabling Russian fonts
font = {'family': 'serif',
	'weight': 'normal'}
rc('font', **font)
rc('text', usetex=True)
rc('text.latex',unicode=True)
rc('text.latex',preamble='\usepackage[utf8]{inputenc}')
rc('text.latex',preamble='\usepackage[russian]{babel}')

nplots = int(input("Enter number of variables on a figure "))

plotid = None
var  = [0]*nplots
time = [0]*nplots
legendcommon = []
for i in range(nplots):
	plotid, time[i], var[i], legendcommon = plot_timeser(plotid,i,legendcommon)

#Calculate root mean square error (RMSE) and correlation coefficient (CC)
if nplots > 1:
	if len(time[0]) > len(time[1]):
		var[0] = nm.interp(time[1],time[0],var[0])
	else:
		var[1] = nm.interp(time[0],time[1],var[1])
	#CC
	var_ = var[0] + var[1]
	var[0] = nm.ma.masked_array(var[0],nm.isnan(var_)) #removing NaNs 
	var[1] = nm.ma.masked_array(var[1],nm.isnan(var_)) #removing NaNs 
	cc = nm.corrcoef(var[0],var[1])
	#print(cc)
	#RMSE
	diff = var[0] - var[1]
	#diff = nm.ma.masked_array(diff,nm.isnan(diff)) #removing NaNs
	diff = abs(diff)
	mae  = nm.sum(diff)/len(diff)
	diff = diff*diff
	rmse = (nm.sum(diff)/len(diff))**0.5
	print('RMSE = ', rmse, '; CC = ', cc[0,1],  ';MAE = ', mae, '; N = ', len(diff))

time_ = nm.zeros(len(time[nplots-1]))
time_[:] = time[nplots-1][:]
#Add analytic curve to the plot
#varanal = phys.KatoPhilDepth(time_*3600.) #3600. - secs in hour
#plt.plot(time[nplots-1],varanal,'r')
#legendcommon.append(u'Аналитическое решение, Price(1979)')
#plt.legend(legendcommon,fontsize=20,loc='best')

#print(time[nplots-1],varanal)

plt.show()
