PROGRAM OUTPUT_PROC

implicit none


integer, parameter :: nvars = 14

integer :: nfiles
integer, allocatable :: file_units(:)
integer :: filevar_units(1:nvars)
integer :: i, k, m, n


real(8), allocatable :: vars(:,:)
real(8) :: time

character(len=100), allocatable :: filenames(:)
character(len=10) :: varnames(1:nvars)
character(len=10) :: work_char ! Work variable


open (unit = 1, file = 'output_proc.dat', status='old')
read (1,'(a)') ! Reading file header
read (1,'(i)') nfiles
allocate (filenames(1:nfiles))
do i = 1, nfiles
  read(1,'(a)') filenames(i)
enddo
  
varnames(1) = 'mltemp'
varnames(2) = 'mtempvc'
varnames(3) = 'btemp'
varnames(4) = 'mldep'
varnames(5) = 'icethick'
varnames(6) = 'snwthick'
varnames(7) = 'tempices'
varnames(8) = 'tempsnws'
varnames(9) = 'shf'
varnames(10) = 'lhf'
varnames(11) = 'momf'
varnames(12) = 'lwf'
varnames(13) = 'dwnhf'
varnames(14) = 'salb'
    
! Opening files with lake models outputs
allocate (file_units(1:nfiles))
file_units(1) = 1
open (unit=file_units(1), file=filenames(1), status='old')
if (nfiles >= 2) then
  do i = 2, nfiles
    file_units(i) = file_units(i-1) + 1
    open (unit=file_units(i), file=filenames(i), status='old')
  enddo
endif
  
! Checking the number of records in files  
do i = 1, nfiles
  m = 0
  do while (.not.eof(file_units(i)))
    read (unit = file_units(i), fmt = '(a)') 
    m = m + 1
  enddo
  rewind(file_units(i))
  if (i /= 1 .and. m /= k) then
    write(*,*) 'The number of records is different in ', i-1, '-th and ', i, '-th output files'
    write(*,*) 'The numbers of records are ', k, m
    read*
    STOP
  else 
    k = m
  endif
enddo
  
! Opening files for particular variables output
filevar_units(1) = file_units(nfiles) + 1
open (unit=filevar_units(1), file=varnames(1), status='unknown')
write (filevar_units(1), 31) 'time', (filenames(i), i = 1, nfiles)
if (nvars >= 2) then
  do i = 2, nvars
    filevar_units(i) = filevar_units(i-1) + 1
    open (unit=filevar_units(i), file=varnames(i), status='unknown')
    write (filevar_units(i), 31) 'time', (filenames(k), k = 1, nfiles)
  enddo
endif

! Reading files and collecting the data in files with particular variables
allocate (vars(1:nvars, 1:nfiles))
do while (.not.eof(file_units(1)))
  k = nvars
  do i = 1, nfiles
    read (unit=file_units(i), fmt = *) time, (vars(m,i), m = 1, nvars) !fmt = 1
  enddo
  k = nfiles
  do i = 1, nvars
    write (unit=filevar_units(i), fmt = 21) time, (vars(i,m), m = 1, nfiles)
  enddo
enddo

deallocate (file_units)
deallocate (filenames)
deallocate (vars)

1 format (f,<k>(f))
21 format (f10.2,<k>(3x,f10.3)) ! mltemp
31 format (a10, <nfiles>(2x,a50))

!22 format (f10.2,<k>(a30,f10.2)) ! mtempvc
!23 format (f10.2,<k>(a30,f10.2)) ! btemp
!24 format (f10.2,<k>(a30,f10.2)) ! mldep
!25 format (f10.2,<k>(a30,f10.2)) ! icethick
!26 format (f10.2,<k>(a30,f10.2)) ! snwthick
!27 format (f10.2,<k>(a30,f10.2)) ! tempices
!28 format (f10.2,<k>(a30,f10.2)) ! tempsnws
!29 format (f10.2,<k>(a30,f10.2)) ! shf
!30 format (f10.2,<k>(a30,f10.2)) ! lhf
!31 format (f10.2,<k>(a30,f10.3)) ! momf
!32 format (f10.2,<k>(a30,f10.2)) ! lwf
!33 format (f10.2,<k>(a30,f10.2)) ! dwnhf
!34 format (f10.2,<k>(a30,f10.2)) ! salb

!10 format (f,<k>(f,f))
!20 format (f,<k>())

END PROGRAM OUTPUT_PROC