#/usr/bin/python

import numpy as np
#Calculates eddy diffusivity according to D'Asaro and Lien, 2000

#Constants
Gamma = 1.
Fr_cr=0.7#critical Groude number
I_0 = 0.15
gamma = 0.24

#Parameters
f=1.19E-4#Coriolis parameter
N=0.2#Brunt-Vaisala frequency
Htherm=5. #thermocline thickness
Phi_w = 1.5E-6 #Spectral 'level' of w fluctuations

SigmaH = 1.E-3 #Horizontal velocity dispersion

m_1 = np.pi/Htherm
#eps = I_0*Gamma*np.pi**2*m_1**2*N**2*Phi_w**2/(4.*Fr_cr**2*f)
eps = I_0*Gamma*m_1**2*f*SigmaH**2/(N**2*Fr_cr**2)
kmin = gamma*eps/N**2

print('eps = ',eps)
print('k = ',kmin)
